<?php

namespace Suiterus\Dms\Controllers\Feature;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Suiterus\Dms\Models\Feature\Feature;
use LaravelFeature\Facade\Feature as FacadeFeature;
use Exception;

class FeatureController extends Controller
{
    public function create(Request $request)
    {
        DB::beginTransaction();
        try {
            $feature = Feature::updateOrCreate(
                ['id' => $request->feature_id],
                [
                    'name' => $request->name,
                    'title' => $request->title,
                    'description' => $request->description,
                    'is_enabled' => $request->is_enabled,
                    'type' => $request->feature_type,
                    'system_id' => $request->system_id
                ]
            );

            DB::commit();
            return $feature;
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in creating new Template.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }

    public function paginate(Request $request)
    {
        $paginate = $request->page_count ? intval($request->page_count) : env('DEFAULT_PAGECOUNT');
        return Feature::where('type', $request->feature_type)->paginate($paginate);
    }

    public function updateIsEnabled(Request $request)
    {
        return Feature::where('id', $request->feature_id)->update([
            'is_enabled' => $request->is_enabled
        ]);
    }

    public function delete(Request $request)
    {
        return Feature::where('id', $request->feature_id)->delete();
    }

    public function isFeatureEnabled(Request $request)
    {
        return FacadeFeature::isEnabled($request->feature_name);
    }

    public function fetch(Request $request)
    {
        $features = Feature::where('is_enabled', $request->is_enabled)->get();

        $returnFeatures = [];
        foreach ($features as $feature) {
            $returnFeatures[$feature['name']] = $feature;
        }

        return $returnFeatures;
    }
}
