<?php

namespace Suiterus\Dms\Controllers\CustomForm;

use Activity;
use Exception;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Suiterus\Dms\Models\Files\File;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Suiterus\Dms\Models\CustomForm\CustomFormValue;
use Suiterus\Dms\Models\Files\FileType;
use App\Models\User;
use App\Traits\Logs\HasCustomLogs;
use Suiterus\Dms\Classes\DriveType;
use Suiterus\Dms\Controllers\Configuration\AllowedFileTypesController;
use Suiterus\Dms\Enums\File\AccessLevel;
use Suiterus\Dms\Enums\Log\FileLogType;
use Suiterus\Dms\Models\Files\FileVersion;
use Suiterus\Dms\Request\File\FileUploadRequest;
use Suiterus\Dms\Services\File\FileService;

class CustomFormValueController extends Controller
{

    private $fileService;

    public function __construct(FileService $fileService)
    {
        $this->fileService = $fileService;
    }

    public function create(FileUploadRequest $request)
    {

        DB::connection(env('DMS_DB_CONNECTION'))->beginTransaction();
        try {
            $file = $request->file('files');

            $file = $this->fileService->uploadFile(
                $request->section,
                $file,
                $request->type,
                $request->documentType,
                $request->privacy,
                $request->option
            );

            $this->fileService->giveFileAccess(
                $file,
                $request->users ?? [],
                $request->groups ?? [],
                AccessLevel::VIEWER
            );
            $fileVersion = $file->versions()->first();

            CustomFormValue::updateOrCreate(
                ['file_version_id' => $fileVersion->id],
                [
                    'custom_form_id' => $request->custom_form_id,
                    'file_version_id' => $fileVersion->id,
                    'form_value' => $request->form_value
                ]
            );

            DB::connection(env('DMS_DB_CONNECTION'))->commit();
            return response()->json([
                'text' =>  $request->file('files')->getClientOriginalName() . ' have been successfully uploaded.',
                'data' => $request->all(),
            ]);
        } catch (Exception $e) {
            DB::connection(env('DMS_DB_CONNECTION'))->rollback();
            return response()->json([
                'errors' => ['Something went wrong in our system. Please contact the developer to fix it.'],
            ], 500);
        }
    }

    public function fetchFileCustomDescription(Request $request)
    {
        $latestFileVersion = FileVersion::where('file_id', $request->file_id)->latest()->first();
        $customFormValue = CustomFormValue::where([
            ['file_version_id', $latestFileVersion->id]
        ])->with(['customForm'])->first();


        if (!isset($customFormValue['form_value'])) {
            return response()->json([
                'message' => 'This file does not have any additional description.'
            ], 400);
        }

        $customFormValue['form_value'] = json_decode($customFormValue['form_value']);

        return $customFormValue;
    }
}
