<?php

namespace Suiterus\Dms\Controllers\CustomForm;

use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Suiterus\Dms\Models\CustomForm\CustomForm;

class CustomFormController extends Controller
{
    public function create(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'form'  =>  'required'
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }
        DB::beginTransaction();
        try {
            CustomForm::updateOrCreate(
                ['document_type_id' => $request->document_type_id],
                [
                    'document_type_id' => $request->document_type_id,
                    'form' => json_encode($request->form)
                ]
            );
            DB::commit();
            return response()->json([
                'text'  =>  'Custom form has been created.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in creating new Template.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }

    public function fetchByID(Request $request)
    {
        $customForm = CustomForm::where('document_type_id', $request->document_type_id)->first();
        if ($customForm) {
            $customForm['form'] = json_decode($customForm['form']);
            return $customForm;
        } else {
            return response()->json([
                'message' => 'Form does not exist'
            ], 404);
        }
    }
}
