<?php

namespace Suiterus\Dms\Controllers\Configuration;


use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Dms\Models\Configuration\DocumentType;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Validator;
use Exception;
use Auth;
use DB;

class DocumentTypeController extends Controller
{
    public function list_document_types(Request $req)
    {
        $paginate = $req->page_count ? intval($req->page_count) : ENV('DEFAULT_PAGECOUNT');
        $data = DocumentType::paginate($paginate);

        return response()->json([
            'message' => 'Fetch successful.',
            'data' => $data,
        ]);
    }

    public function show(string $id){
        return DocumentType::find($id);
    }

    public function fetch_all_document_types(Request $req)
    {
        return DocumentType::where('status', $req->status)->get();
    }

    public function create_document_type(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'name'  =>  'required|min:3|string|',
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {
            DocumentType::create([
                'name' => $req->name,
            ]);

            DB::commit();
            return response()->json([
                'text'  => ' Document type has been created.',
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Something went wrong in our system. Please contact the developer to fix it.'],
                'message'   =>  $e->getMessage()
            ], 500);
        }
    }

    public function delete_document_type(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'id' => 'required|numeric|exists:dms_db.document_types,id',
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {
            DocumentType::whereId($req->id)->delete();

            DB::commit();
            return response()->json([
                'text'  => ' Document type has been deleted.',
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Something went wrong in our system. Please contact the developer to fix it.'],
                'message'   =>  $e->getMessage()
            ], 500);
        }
    }

    public function update_document_type(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'id' => 'required|numeric|exists:dms_db.document_types,id',
            'status' => 'required|boolean',
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {
            $data = DocumentType::whereId($req->id)->update([
                'status' => $req->status? 1 : 2,
            ]);
            DB::commit();
            return response()->json([
                'text'  => 'Document type has been updated.',
                'data' => $data
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Something went wrong in our system. Please contact the developer to fix it.'],
                'message'   =>  $e->getMessage()
            ], 500);
        }
    }
}
