<?php

namespace Suiterus\Dms\Controllers\Configuration;

use Illuminate\Support\Facades\Storage;
use Suiterus\Dms\Models\Configuration\ConfigHeaderLogo;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class ConfigHeaderLogoController extends controller{

    public function file_download(Request $req){
        $valid = Validator::make($req->all(),[
            'path'  =>  'required'
        ]);

        if($valid->fails()){
            return response()->json([
                'error' => $valid->errors()
            ], 400);
        }
        return Storage::download($req->path);
    }

    public function updateCreate(Request $request) {

        $validate = Validator::make($request->all(), [
            'logo_file'          => 'required|nullable|file|mimes:jpg,jpeg,png'
        ]);

        $path = $request->logo_file->store('header_logo');
        if($validate->fails()) {
            return response()->json([
                'errors'    => $validate->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {

            ConfigHeaderLogo::updateOrCreate([
                'id' => $request->id
            ],
            [
                'path' => $path,
                'created_by' => Auth::user()->id,
                'updated_by' => Auth::user()->id
            ]);
            DB::commit();
            return response()->json([
                'text'  => 'File has been uploaded.'
            ]);

        } catch(Exception $e) {
            DB::rollBack();
            return response()->json([
                'errors'    => ['There was a problem with creating the path'],
                'message'   => $e->getMessage(),
            ], 500);
        }

    }

    public function fetch_path(){
        return response()->json([
            'data'  =>  ConfigHeaderLogo::first()
        ]);
    }



}