<?php

namespace Suiterus\Dms\Controllers\Configuration;


use Suiterus\Dms\Models\Configuration\ConfigEmail;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
class ConfigEmailController  extends controller{

    public function updateCreateEmail(Request $request) {
 
        $validate = Validator::make($request->all(), [
            'host_name'          => 'required|string',
            'smtp_auth'          => 'required|string',
            'email'              => 'required|string',
            'password'           => 'required|string',
            'mailer'             => 'required|string',
            'smtp_secure'        => 'required|string',
            'port'               => 'required|string',
            'mail_from_name'               => 'required|string',
            'notification_status'=> 'required|integer'
        ]);

        if($validate->fails()) {
            return response()->json([
                'errors'    => $validate->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {

            $configEmail = ConfigEmail::updateOrCreate([
                'id' => $request->id
            ],
            [
                'host_name' => $request->host_name,
                'smtp_auth' => $request->smtp_auth,
                'email'     => $request->email,
                'password'  => bcrypt($request->password),
                'mailer'    => $request->mailer,
                'smtp_secure' => $request->smtp_secure,
                'port'      => $request->port,
                'mail_from_name' => $request->mail_from_name,
                'notification_status'=> $request->notification_status,
                'created_by' => Auth::user()->id,
                'updated_by' => Auth::user()->id
            ]);
            DB::commit();

          $this->setEnv('MAIL_DRIVER', '"' . getenv('MAIL_DRIVER') . '"' , '"' .  $request->smtp_auth . '"' ?? getenv('MAIL_DRIVER'));
            $this->setEnv('MAIL_HOST', '"' . getenv('MAIL_HOST') . '"' , '"' .  $request->host_name . '"' ?? getenv('MAIL_HOST'));
            $this->setEnv('MAIL_PORT', '"' . getenv('MAIL_PORT') . '"' , '"' .  $request->port . '"' ?? getenv('MAIL_PORT'));
            $this->setEnv('MAIL_USERNAME', '"' . getenv('MAIL_USERNAME') . '"' , '"' .  $request->email . '"' ?? getenv('MAIL_USERNAME'));
            $this->setEnv('MAIL_PASSWORD', '"' . getenv('MAIL_PASSWORD') . '"' , '"' .  $request->password . '"' ?? getenv('MAIL_PASSWORD'));
            $this->setEnv('MAIL_ENCRYPTION', '"' . getenv('MAIL_ENCRYPTION') . '"' ,  '"' .  $request->smtp_secure . '"' ?? getenv('MAIL_ENCRYPTION'));
            $this->setEnv('MAIL_FROM_ADDRESS', '"' . getenv('MAIL_FROM_ADDRESS') . '"' , '"' .  $request->mailer . '"' ?? getenv('MAIL_FROM_ADDRESS'));
            $this->setEnv('MAIL_FROM_NAME', '"' . getenv('MAIL_FROM_NAME') . '"' , '"' . $request->mail_from_name . '"' ?? getenv('MAIL_FROM_NAME'));
            
            return response()->json([
                'text'  => $configEmail->configEmail . ' Mail has been created.'
            ]);

        } catch(Exception $e) {
            DB::rollBack();
            return response()->json([
                'errors'    => ['There was a problem with creating the path'],
                'message'   => $e->getMessage(),
            ], 500);
        }

    }

    public function init_list_config_email(Request $req){
        $paginate = $req->page_count ? intval($req->page_count) : env('DEFAULT_PAGECOUNT');
        return response()->json([
            'data'  =>  ConfigEmail::orderBy('id', 'DESC')->paginate($paginate)
        ]);
    }

    private function setEnv($key, $envValue, $value){
        file_put_contents(app()->environmentFilePath(), str_replace(
            $key . '=' . $envValue,
            $key . '=' . $value,
            file_get_contents(app()->environmentFilePath())
        ));
    }

}
