<?php

namespace Suiterus\Dms\Controllers\Configuration;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Suiterus\Dms\Models\Configuration\AllowedFileTypes;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Suiterus\Dms\Models\Files\FileType;

class AllowedFileTypesController extends Controller
{
    
    public function create_file_type(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'file'                => 'required|array',
            'file.*.file_type'    => 'required|string',
            'file.*.unit_byte'    => 'required',
            'file.*.value'        => 'required'
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();
        try {

            foreach ($req->file as $value) {
                FileType::updateOrCreate(
                    [
                        'id' => $value['id'],
                    ],
                    [
                        'file_ext' => $value['file_type'],
                        'unit_byte' => $value['unit_byte'],
                        'value' => $value['value'],
                        'status' => $value['status'],
                    ]
                );
            }

          
            DB::commit();
            return response()->json([
                'text' => 'File types have been created.',
            ]);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json(
                [
                    'errors' => ['Can`t create your entry as of now. Contact the developer to fix it. Error Code : AM-comp-0x05'],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
    }

    public function init_list_file_types(Request $req){
        return FileType::get();
    }

    public function delete_file_type(Request $request) {

        DB::beginTransaction();
        try {

            $id = FileType::findOrFail($request->id);
            $id->delete();
            DB::commit();
            return response()->json([
                'text'  => 'File type has been deleted.'
            ]);
            
        } catch(ModelNotFoundException $me) {
            DB::rollBack();
            return response()->json([
                'errors'    => ["File type doesn't exist"],
                'message'   => $me->getMessage()
            ], 500);
        } catch(Exception $e) {
            DB::rollBack();
            return response()->json([
                'errors'    => ['There was a problem in deleting the record'],
                'message'   => $e->getMessage()
            ], 500);
        }

    }

    public static function getType()
    {
        $allowed = FileType::where('status', '=', '1')->pluck('file_ext');
        $allowed = str_replace('"', "", $allowed);
        $allowed = str_replace(array('[', ']'), '', $allowed);
        $allowed = $allowed . ',' . strtolower($allowed);

        return $allowed;
    }

    public function fetchAllowedTypes()
    {
        return response()->json([
            'data'  => FileType::where('status', '=', '1')->pluck('file_ext')
        ]);
    }

}