<?php

namespace Suiterus\Dms\Controllers\Approvals;

use Activity;
use Exception;
use App\Models\User;
use Illuminate\Http\Request;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Dms\Enums\Log\FileLogType;
use App\Http\Classes\NotificationMessage;
use Illuminate\Support\Facades\Validator;
use Suiterus\Dms\Models\Files\FileAccess;
use Suiterus\Dms\Models\Files\FileVersion;
use Suiterus\Dms\Enums\Log\ApprovalLogType;
use Suiterus\Dms\Models\Approvals\Approval;
use Suiterus\Dms\Services\File\FileService;
use Suiterus\Dms\Models\NotificationMessages;
use Suiterus\Dms\Models\Approvals\FileApprover;
use Suiterus\Dms\Models\Approvals\UserApprover;
use App\Http\Controllers\Systems\NotificationController;
use Suiterus\Dms\Controllers\NotificationMessagesController;
use App\Models\AccessManagement\GroupManagement\ModelHasRole;

class ApprovalController extends Controller
{

    use HasCustomLogs;

    private $fileService;

    public function __construct(FileService $fileService)
    {
        $this->fileService = $fileService;
    }

    /**
     * It creates an approval, then creates a file approver, then creates a user approver.
     * </code>
     * 
     * @param Request request 
     */
    public function create(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'file_version_id' => 'required|exists:' . env('DMS_DB_CONNECTION') . '.file_versions,id',
            'file_id' => 'required|exists:' . env('DMS_DB_CONNECTION') . '.files,id',
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors' => $valid->errors(),
            ], 400);
        }

        $file = FileVersion::findOrFail($request->file_version_id);
            
        $type = $this->fileService->getRepositoryType($file->file->type);
        $permission =  User::where('id', Auth::user()->id)
            ->whereHas('permissions', function ($query) use ($type) {
                $query->where('name','approval document '.$type.' drive');
            })->first();
        
        if(!$permission){
            return response()->json([
                'errors' => ['You do not have the required authorization.'],
            ], 403);
        }

        DB::connection(env('DB_DMS_CONNECTION'))->beginTransaction();
        try {
            $approval = Approval::create([
                'file_version_id' => $request->file_version_id,
                'user_id' => Auth::id(),
                'subject' =>  $request->subject,
                'message' => $request->message,
                'status' => 4
            ]);
            $index = 1;
            foreach ($request->approvers as $approver) {
                if ($approver['radioGroup'] == 1) {
                    $fileApprover = FileApprover::create([
                        'approval_id' => $approval->id,
                        'sequence' => $index,
                        'is_approving' => $index == 1 ? true : false,
                        'approve' => $approver['approved'],
                        'reject' => $approver['rejected'],
                        'status' => 3
                    ]);

                    foreach ($approver['internalUser'] as $user) {
                        $userApprover = UserApprover::create([
                            'user_id' => $user,
                            'level_of_approver_id' => $approver['level_of_approver'] ?? null,
                            'file_approver_id' => $fileApprover->id,
                            'status' => 5
                        ]);

                        $userApproverCollection = UserApprover::with([
                            'fileApprover.approval.file'
                        ])->find($userApprover->id);

                        $this->logCustomMessage('file_approval', $userApproverCollection, Auth::user()->name . ' has submitted a document for approval (' . $userApproverCollection->fileApprover->approval->file->file_name . ') to ' . $userApproverCollection->user->name, $userApproverCollection, ApprovalLogType::APPROVAL, new Activity());


                        FileAccess::create([
                            'user_id' => $user,
                            'file_id' => $request->file_id,
                            'group_id' => null,
                            'access_level' => 1,
                            'shared_by' => Auth::id(),
                            'shared_date' => now()
                        ]);
                        if ($index == 1) {
                            NotificationMessage::notifySenderAndReceiver('Approval', $user, Auth::id(), $userApprover->id);
                        }
                    }
                    $index++;
                } else if ($approver['radioGroup'] == 2) {

                    $users = [];

                    foreach ($approver['internalGroup'] as $group) {
                        $fileApprover = FileApprover::create([
                            'approval_id' => $approval->id,
                            'role_id' => $group,
                            'sequence' => $index,
                            'is_approving' => $index == 1 ? true : false,
                            'approve' => $approver['approved'],
                            'reject' => $approver['rejected'],
                            'status' => 3
                        ]);
                        $users = [...ModelHasRole::select('model_id')->where('role_id', $group)->get()];
                    }



                    foreach ($users as $user) {
                        $isUserAlreadyApproving = UserApprover::where([
                            ['user_id', $user['user']['id']],
                            ['file_approver_id', $fileApprover->id]
                        ])->first();
                        if (!$isUserAlreadyApproving) {
                            $userApprover = UserApprover::create([
                                'user_id' => $user['user']['id'],
                                'level_of_approver_id' => $approver['level_of_approver'] ?? null,
                                'file_approver_id' => $fileApprover->id,
                                'status' => 5
                            ]); 

                            $userApproverCollection = UserApprover::with([
                                'fileApprover.approval.file'
                            ])->find($userApprover->id);

                            $this->logCustomMessage('file_approval', $userApproverCollection, Auth::user()->name . ' has submitted a document for approval (' . $userApproverCollection->fileApprover->approval->file->file_name . ') to ' . $userApproverCollection->user->name, $userApproverCollection, ApprovalLogType::APPROVAL, new Activity());

                            FileAccess::create([
                                'user_id' => $user['user']['id'],
                                'file_id' => $request->file_id,
                                'group_id' => null,
                                'access_level' => 1,
                                'shared_by' => Auth::id(),
                                'shared_date' => now()
                            ]);
                            if ($index == 1) {
                                NotificationMessage::notifySenderAndReceiver('Approval', $user['user']['id'], Auth::id(), $userApprover->id);
                            }
                        }
                    }
                    $index++;
                }
            }
            DB::connection(env('DB_DMS_CONNECTION'))->commit();
        } catch (Exception $e) {
            DB::connection(env('DB_DMS_CONNECTION'))->rollBack();
            return response()->json([
                'errors' => ['Can`t create your entry as of now. Contact the developer to fix it. Error Code : AM-comp-0x05'],
                'msg' => $e->getMessage(),
            ], 500);
        }
    }

    public function isOngoingApproval(Request $request){
        $approval = Approval::where([
            ['file_version_id', $request->file_version_id]
        ])->first();
        if ($approval) {
            return $approval;
        }
        return 'false';
    }
}
