<?php

namespace Suiterus\Dms\Controllers\ApprovalTemplate;

use Activity;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Traits\Logs\HasCustomLogs;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Suiterus\Dms\Models\ApprovalTemplate\UserHasAdminTemplate;
use Suiterus\Dms\Models\ApprovalTemplate\AdminApprovalTemplate;
use Suiterus\Dms\Enums\Log\AdminApprovalTemplate as LogAdminApprovalTemplate;

class UserHasAdminTemplateController extends Controller
{

    use HasCustomLogs;

    public function create(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'admin_approval_template_id'  =>  'required|exists:' . env('DMS_DB_CONNECTION') . '.admin_approval_templates,id',
            'users' => 'required'
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }
        DB::connection(env('DMS_DB_CONNECTION'))->beginTransaction();
        try {

            $queryBuilder = UserHasAdminTemplate::where('admin_approval_template_id', $request->admin_approval_template_id);

            $deletedMembers = $queryBuilder->whereNotIn('user_id', $request->users)->get();
            $currentMembers = $queryBuilder->get()->pluck('user_id');

            foreach ($deletedMembers as $member) {
                $this->logCustomMessage(
                    'revoke_access_approval_template',
                    $member,
                    'Access to the approval template named ' . $member->approvalTemplate->name . ' was revoked for ' . $member->user->name . ' by ' . Auth::user()->name,
                    $member,
                    LogAdminApprovalTemplate::REVOKE_ACCESS,
                    new Activity()
                );
            }

            foreach ($request->users as $user) {
                $userHasAdminTemplate = UserHasAdminTemplate::create([
                    'user_id' => $user,
                    'admin_approval_template_id' => $request->admin_approval_template_id
                ]);

                if (!in_array($user, $currentMembers->toArray())) {
                    $this->logCustomMessage(
                        'grant_access_approval_template',
                        $userHasAdminTemplate,
                        $userHasAdminTemplate->user->name . ' was granted access to the approval template named ' . $userHasAdminTemplate->approvalTemplate->name . ' by ' . Auth::user()->name,
                        $userHasAdminTemplate,
                        LogAdminApprovalTemplate::GRANT_ACCESS,
                        new Activity()
                    );
                }
            }

            $queryBuilder->delete();

            DB::connection(env('DMS_DB_CONNECTION'))->commit();
            return response()->json([
                'text'  =>  'Access has been created for each users.'
            ]);
        } catch (Exception $e) {
            DB::connection(env('DMS_DB_CONNECTION'))->rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in creating new Access.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }

    public function search(Request $request)
    {
        $this->logCustomMessage(
            'search_approval_template',
            null,
            Auth::user()->name . ' searched for approval template named "' . $request->name . '"',
            null,
            LogAdminApprovalTemplate::SEARCH,
            new Activity()
        );
        return AdminApprovalTemplate::whereHas('userAccessTemplate', function ($query) use ($request) {
            $query->where('user_id', $request->user_id);
        })->where('name', 'LIKE', '%' . $request->name . '%')->take(10)->get();
    }

    public function paginateByUser(Request $request)
    {
        return AdminApprovalTemplate::whereHas('userAccessTemplate', function ($query) use ($request) {
            $query->where('user_id', $request->user_id);
        })->paginate(3);
    }

    public function fetchByTemplate(Request $request)
    {
        return UserHasAdminTemplate::select('user_id')->where('admin_approval_template_id', $request->id)->get();
    }
}
