<?php

namespace Suiterus\Dms\Controllers\ApprovalTemplate;

use Activity;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Traits\Logs\HasCustomLogs;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Suiterus\Dms\Enums\Log\AdminApprovalTemplate;
use Suiterus\Dms\Models\ApprovalTemplate\UserApprovalTemplate;

class UserApprovalTemplateController extends Controller
{

    use HasCustomLogs;

    public function create(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'template_name' => 'required',
            'template' => 'required',
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors' => $valid->errors(),
            ], 400);
        }
        DB::connection(env('DMS_DB_CONNECTION'))->beginTransaction();
        try {
            $old = UserApprovalTemplate::find($request->id);
            $template = UserApprovalTemplate::updateOrCreate(
                ['id' => $request->id],
                [
                    'user_id' => Auth::id(),
                    'name' => $request->template_name,
                    'template' => json_encode($request->template)
                ]
            );
            $updated = UserApprovalTemplate::find($request->id);
            if ($request->id) {
                $template->old = collect($old);
                $template->attributes = collect($updated);
                $this->logCustomMessage(
                    'update_approval_template',
                    $template,
                    Auth::user()->name . ' updated a template named ' . $template->name,
                    $template,
                    AdminApprovalTemplate::UPDATE,
                    new Activity()
                );
            }else {
                $this->logCustomMessage(
                    'create_approval_template',
                    $template,
                    Auth::user()->name . ' created a template named ' . $template->name,
                    $template,
                    AdminApprovalTemplate::CREATE,
                    new Activity()
                );
            }
            DB::connection(env('DMS_DB_CONNECTION'))->commit();
            return response()->json([
                'text'  =>  'Template has been created.'
            ]);
        } catch (Exception $e) {
            DB::connection(env('DMS_DB_CONNECTION'))->rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in creating new Template.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }

    public function paginate()
    {
        return UserApprovalTemplate::where('user_id', Auth::id())->paginate(3);
    }

    public function search(Request $request)
    {
        return UserApprovalTemplate::where('name', 'LIKE', '%' . $request->name . '%')->take(10)->get();
    }

    public function delete(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'id' => 'required|exists:' . env('DMS_DB_CONNECTION') . '.user_approval_templates,id'
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors' => $valid->errors(),
            ], 400);
        }
        DB::connection(env('DMS_DB_CONNECTION'))->beginTransaction();
        try {
            $userApprovalTemplate = UserApprovalTemplate::where('id', $request->id);
            $template = $userApprovalTemplate->first();
            $this->logCustomMessage(
                'delete_approval_template',
                $template,
                Auth::user()->name . ' deleted an approval template named ' . $template->name,
                $template,
                AdminApprovalTemplate::DELETE,
                new Activity()
            );
            $userApprovalTemplate->delete();
            DB::connection(env('DMS_DB_CONNECTION'))->commit();
            return response()->json([
                'text'  =>  'Template deleted.'
            ]);
        } catch (Exception $e) {
            DB::connection(env('DMS_DB_CONNECTION'))->rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in delete a Template.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }
}
