<?php

namespace Suiterus\Dms\Controllers\AccessManagement;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Carbon\Carbon;
use Validator;
use Auth;
use DB;


class UserTypeController extends Controller
{
    
    public function list_user_types(Request $req){
        
        $paginate = $req->page_count ? intval($req->page_count) : ENV('DEFAULT_PAGECOUNT');
        
        $data = Role::paginate($paginate);

        return response()->json([
       
            'message' => 'Fetch successful.',
            'data' => $data,

        ]);
    }

    
    public function search_user_type(Request $req){
       
        $valid = Validator::make($req->all(),[
            'keyword'   =>  'required|min:2'
        ]);

        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        
        try{
            $paginate = $req->page_count ? intval($req->page_count) : ENV('DEFAULT_PAGECOUNT');
            return response()->json([

                'data'  =>  Role::where('name', 'LIKE', '%'.$req->keyword.'%')->paginate($paginate)
            
            ]);

        }catch(\Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong while processing your request' ],
                'message'   =>  $e->getMessage()
            ],500);
        }
    }
    

    public function fetch_user_type_by_id(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'id' => 'required|numeric',
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
       
        $paginate = $req->page_count ? intval($req->page_count) : ENV('DEFAULT_PAGECOUNT');
        
        $role = Role::where('id', $req->id)->get();
        $rolePermissions = Permission::join('role_has_permissions', 'role_has_permissions.permission_id', 'permissions.id')
                ->where('role_has_permissions.role_id',$req->id)
                ->paginate($paginate);
    
        $data = $role->merge($rolePermissions);
        
        return response()->json([
            'message' => 'Fetch successful.',
            'data' => $data
        ]);
    }
    

    public function edit_user_type_permissions(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'id' => 'required',
            'permission' => 'required',
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
               
        $role = Role::findById($req->id);
        $role->save();

        $permissions = $req->input('permission');
       
        $role->syncPermissions($permissions);
        
        $data = $role;
        
        return response()->json([
            'message' => 'Fetch successful.',
            'data' => $data,
            
        ]);
    }
   



}
