<?php

namespace Suiterus\Dms\Controllers\AccessManagement;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Carbon\Carbon;
use Validator;
use Auth;
use DB;


class UserManagementController extends Controller
{
    
    public function fetch_user_by_roles(Request $req){
       
        $valid = Validator::make($req->all(),[
            'id'   =>  'required|numeric'
        ]);

        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        
        try{
            $paginate = $req->page_count ? intval($req->page_count) : ENV('DEFAULT_PAGECOUNT'); 
            $data =  Role::with('users')->where('id', $req->id)->select('id','name')->paginate($paginate); 
          
            return response()->json([

                'data'  =>  $data
       
            ]);
            
        }catch(\Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong while processing your request' ],
                'message'   =>  $e->getMessage()
            ],500);
        }
    }

    public function edit_assigned_user_role(Request $req){
               
        try{

            $valid = Validator::make($req->all(), [
                'user_id' => 'required|numeric|exists:mysql.users,id',
                'id' => 'required',
                
            ]);
            if ($valid->fails()) {
                return response()->json(
                    [
                        'errors' => $valid->errors(),
                    ],
                    400
                );
            }

           
            $user = User::findOrfail($req->user_id);  
            $role = Role::findById($req->id);
          
            $user->syncRoles($role->name);

            return response()->json([

                'data'  =>  $user
   
            ]);

        }catch(\Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong while processing your request' ],
                'message'   =>  $e->getMessage()
            ],500);
        }
    }

    
}
