<?php

namespace Suiterus\Dms\Controllers\AccessManagement;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


use Suiterus\Dms\Classes\UserAccess;
use Suiterus\Dms\Models\Files\File;

class UserAccessController extends Controller
{

    public function checkFileAccess(Request $request)
    {
        $user = User::where('id', Auth::user()->id)->first();
        $roles = $user->roles->pluck('id');

        $file = File::find($request->file_id);

        if ($file) {
            if ($file->type == 2) {
                return response()->json([
                    'message' => 'Has access',
                ], 200);
            }
        }

        $fileAccess = UserAccess::traverseFileTreeAccess($request->file_id, $roles);

        if ($fileAccess) {
            return response()->json([
                'message' => 'Has access',
            ], 200);
        } else {
            return response()->json([
                'message' => 'No access',
            ], 403);
        }
    }

    public function checkSectionAccess(Request $request)
    {
        $user = User::where('id', Auth::user()->id)->first();

        $roles = $user->roles->pluck('id');

        $sectionAccess = UserAccess::traverseFolderTreeAccess($request->section_id, $roles);

        if ($sectionAccess) {
            return response()->json([
                'message' => $user->name . ' has section access'
            ], 200);
        } else {
            return response()->json([
                'message' => $user->name . ' has no section access'
            ], 404);
        }
    }
}
