<?php

namespace Suiterus\Dms\Controllers\AccessManagement;

use App\Models\User;
use App\Http\Controllers\Controller;
use App\Models\AccessManagement\GroupManagement\RoleHasPermission;
use Illuminate\Support\Facades\Auth;

class PermissionController extends Controller
{
    public function fetch_permissions()
    {
        $user = User::findOrFail(Auth::user()->id);

        $userRoles = $user->roles;

        foreach ($user->permissions as $permissions) {
            $name = str_replace(' ', '_', $permissions['name']);
            $value[$name] = $permissions;
        }

        foreach ($userRoles as $userRole) {
            $rolePermissions = RoleHasPermission::where('role_id', $userRole['id'])->with(['permission'])->get();
            $name = str_replace(' ', '_', $userRole->name);
            $value[$name] = $userRole;
            if (count($rolePermissions) > 0) {
                foreach ($rolePermissions as $rolePermissions) {
                    $name = str_replace(' ', '_', $rolePermissions->permission->name);
                    $value[$name] = $permissions;
                }
            }
        }
        return response()->json([
            'data' => $value,
        ]);
    }
}
