<?php

namespace Suiterus\Dms\Contracts\Repositories;

use Illuminate\Http\JsonResponse;

interface Folder
{
    // Option value is: 'continue'
    public function createFolder(string $folderName, string $description, int $parentId, int $driveType, array $users, array $groups, $option): JsonResponse;

    public function renameFolder(int $sectionId, string $folderName, string $description, int $parentId, string $option, int $driveType, array $users, array $groups): JsonResponse;
    
    public function fetchFolder(int $page, int $parentSectionId, int $driveType): JsonResponse;

    public function fetchFolderFile(int $sectionId, int $driveType, int $page);

    public function moveFolder(array $folders, int $folderId): JsonResponse;

    public function copyFolder(array $folders, int $folderId): JsonResponse;

    public function deleteFolder(array $folders);
}
