<?php

namespace Suiterus\Dms\Classes;

use Suiterus\Dms\Models\Files\File;
use Illuminate\Support\Facades\Auth;
use Suiterus\Dms\Models\Files\FileAccess;
use Suiterus\Dms\Models\Repositories\Section;
use Suiterus\Dms\Models\Repositories\SectionAccess;

class UserAccess
{
    public static function traverseFileTreeAccess($fileId, $roles)
    {
        $fileAccess = FileAccess::where([
            ['user_id', Auth::user()->id],
            ['file_id', $fileId]
        ])->orWhereIn('group_id', $roles)->whereHas('file', function ($query) use ($roles) {
                $query->orWhereHas('section', function ($query) use ($roles) {
                    $query->orWhereHas('access', function ($query) use ($roles) {
                        $query->where('user_id', Auth::user()->id)->orWhereIn('group_id', $roles);
                    });
                });
            })
            ->first();

        if ($fileAccess) {
            return $fileAccess;
        }

        $file = File::find($fileId);

        return UserAccess::traverseFolderTreeAccess($file->section_id, $roles);
    }

    public static function traverseFolderTreeAccess($sectionId, $roles)
    {

        $sectionAccess = SectionAccess::where([
            ['user_id', Auth::user()->id],
            ['section_id', $sectionId]
        ])->orWhereIn('group_id', $roles)->where([
            ['section_id', $sectionId]
        ])->first();

        if ($sectionAccess) {
            return $sectionAccess;
        }

        $section = Section::where('id', $sectionId)->first();

        if (!$section) {
            return null;
        }

        if ($section->parent_id != 0) {
            return UserAccess::traverseFolderTreeAccess($section->parent_id, $roles);
        }
    }
}
