<?php

namespace Suiterus\Adg\Traits;

/**
 * This EmployerTrait that encapsulates basic information about an employer from the provided object.
 * It initializes the employer's info, such as name and id, from the given object.
 * @param Object $employer - @see User.php data of the employer
 *
 */

trait EmployerTrait
{
    protected String $employers_name;
    protected String $employer_id;

    public function initializeEmployerInfo($employer)
    {
        $this->employers_id = isset($employer->employeeMetaInfo) ? $employer->employeeMetaInfo->corporation->employer_id : "";
        $this->employers_name = isset($employer->employeeMetaInfo) ? $employer->employeeMetaInfo->corporation->name : "";
        $this->office_code = isset($employer->employeeMetaInfo) ? $employer->employeeMetaInfo->corporation->office_code : "";
    }
}
