<?php

namespace Suiterus\Adg\Traits;

use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\Activity\Audit;

trait Auditable
{

    public static function boot()
    {
        static::created(function ($model) {
            $className = get_class($model);
            $modelCopy = new $className;
            $data = $modelCopy->with($model->auditRelations ?? [])->find($model->id);

            $historyModel = $model->historyModel ?? Audit::class;

            $historyModel::create([
                'causer_type' => get_class(Auth::user()),
                'causer_id' => Auth::id(),
                'auditable_type' => get_class($data),
                'auditable_id' => $model->id,
                'event' => 'created',
                'new_data' => $data,
            ]);
        });

        parent::boot();
    }

    public function audits(){
        return $this->morphMany($this->historyModel ?? Audit::class, 'model');
    }
}
