<?php


namespace Suiterus\Adg\Services\Time;

use Carbon\Carbon;

class TimeService 
{
    /** 
    * It calculates the total sum of time
    * @param array times array of time to be calculated
    */
    public static function calculateTotalTime(array $times){


        $minutes = 0;

        foreach($times as $time){
            if($time){
                sscanf($time, '%d:%d', $hour, $min);
                $minutes += $hour * 60 + $min;
            }
            
        }

        if($h = floor($minutes / 60)){

            $minutes %= 60;

        }

        return sprintf('%02d:%02d', $h, $minutes);




    }

    public static function hoursToMinutes($time){
        $time = explode(':', $time);
        return ($time[0]*60) + ($time[1]);
    }

    public static function calculateTotalDateTime($date1, $date2) 
    {
        $dateTime1 = Carbon::parse($date1);
        $dateTime2 = Carbon::parse($date2);

        $timeDifference = $dateTime2->diffInSeconds($dateTime1);
        return Carbon::parse(gmdate('H:i', $timeDifference))->format('G:i');
    }
   
}
