<?php

namespace Suiterus\Adg\Services\SPMS;

use Exception;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Adg\Models\SM\OfficePerEmployee;
use Suiterus\Adg\Models\SPMS\MetricEvaluation;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Suiterus\Adg\Services\OrgStructure\OrgStructureService;

class MetricEvaluationService
{
    public static function compute_average_mfo_entry($request)  {
        $total = 0.00;
        $average = 0.00;

        $rating_arr = [
            $request->rate_q,
            $request->rate_e,
            $request->rate_t,
        ];

        $filtered_arr = array_filter($rating_arr, function ($value) {
            return is_numeric($value);
        });

        $total = array_sum($filtered_arr);
        $count = count($filtered_arr);
        $average = ($count > 0) ? $total / $count : 0;
        return floatval(number_format($average, 2));
    }


    public static function compute_overall_rating($employee_evaluation)
    {
        $overall_rating = 0.00;

        foreach ($employee_evaluation->performanceEvaluations as $performance_evaluation) {
            $overall_rating += $performance_evaluation->overall_rate;
        }

        return floatval(number_format($overall_rating, 2));
    }


    public static function compute_overall_rating_per_mfo($request, $performance_evaluation)
    {
        $overall_rating = 0.00;
        $performance_rating = 0.00;
        $mfoRateQ = 0.00;
        $countQ = 0;
        $mfoRateE = 0.00;
        $countE = 0;
        $mfoRateT = 0.00;
        $countT = 0;
        $mfoAverage = 0.00;
        $count = 0;

        foreach ($performance_evaluation->metricEvaluations as $metric_evaluation) {
            if (!is_null($metric_evaluation->average)) {
                $mfoAverage += $metric_evaluation->average;
                $performance_rating += $metric_evaluation->average;
            }
            if (!is_null($metric_evaluation->rate_q)) {
                $mfoRateQ += $metric_evaluation->rate_q;
                $countQ++;
            }
            if (!is_null($metric_evaluation->rate_e)) {
                $mfoRateE += $metric_evaluation->rate_e;
                $countE++;
            }
            if (!is_null($metric_evaluation->rate_t)) {
                $mfoRateT += $metric_evaluation->rate_t;
                $countT++;
            }

            $count++;
        }

        $mfoRateQ = ($countQ > 0) ? $mfoRateQ / $countQ : 0;
        $mfoRateE = ($countE > 0) ? $mfoRateE / $countE : 0;
        $mfoRateT = ($countT > 0) ? $mfoRateT / $countT : 0;
        $overall_rating = ($count > 0) ? $performance_rating / $count : 0;

        $employee_evaluation = EmployeeEvaluation::whereId($request->employee_evaluation_id)->first();

        // Determine PCR type
        $review_form_type_id = $employee_evaluation->review_form_type;

        $orgStructureService = new OrgStructureService();

        $evaluationFormOrganization = $employee_evaluation->unit;
        $evaluationFormOrganization = $evaluationFormOrganization ?? $employee_evaluation->section;
        $evaluationFormOrganization = $evaluationFormOrganization ?? $employee_evaluation->division;
        $evaluationFormOrganization = $evaluationFormOrganization ?? $employee_evaluation->department;
        $evaluationFormOrganization = $evaluationFormOrganization ?? $employee_evaluation->office;

        if (!$evaluationFormOrganization) {
            throw new Exception('Employee organization not found');
        }

        $pcrs = $orgStructureService->getPcrConfig($evaluationFormOrganization);

        if (!$pcrs->where('pcr_form_type_id', $review_form_type_id)->first()) {
            throw new Exception('PCR config not found, please contact your administrator');
        }

        $percentage = $pcrs->where('pcr_form_type_id', $review_form_type_id)->first()->mfos()->where('mfo_id', $request->mfo)->first()->percentage ?? 0;

        $mfo_percentage = ($percentage/100);
        $weighted_average = $overall_rating * $mfo_percentage;

        $performance_evaluation->update([
            'rate_q_ave' => $mfoRateQ,
            'rate_e_ave' => $mfoRateE,
            'rate_t_ave' => $mfoRateT,
            'average' => $overall_rating,
            'overall_rate' => number_format($weighted_average, 2),
            'percentage' => $mfo_percentage
        ]);

        return floatval(number_format($weighted_average, 2));
    }

    private static function get_percentage_by_review_form_type($review_form_type_id) // 1 - Core | 2 - Strategic | 3 - Support
    {
        $default_percentage = [1 => 0.70, 2 => 0, 3 => 0.30];
        $special_percentage = [
            5 => [1 => 0.40, 2 => 0.50, 3 => 0.10], // DePCR
            6 => [1 => 0.40, 2 => 0.50, 3 => 0.10], // DDPCR
            8 => [1 => 0.40, 2 => 0.50, 3 => 0.10], // APCR
        ];
        return $special_percentage[$review_form_type_id] ?? $default_percentage;
    }

    private static function determine_office($employee_evaluation)
    {
        $review_form_type = $employee_evaluation->review_form_type;

        if ($review_form_type >= 1 && $review_form_type <= 8) {
            $office_id = null;

            $has_office = OfficePerEmployee::where('user_id', $employee_evaluation->employee_id)->first();
            if ($has_office) {
                $office_id = $has_office->office_id;

                // Do not remove this block of code.
                // $office_has_parent_office = OfficeHierarchy::where('child_office_id', $office_id)->first();
                // if ($office_has_parent_office) {
                //     $office_id = $office_has_parent_office->parent_office_id;
                // }
            }

            // Check if department has office
            $employee_meta_info = EmployeeMetaInfo::where('user_id', $employee_evaluation->employee_id)->first();
            $department_has_office = Department::whereId($employee_meta_info->department_id)->whereHas('office')->first();
            if ($department_has_office) {
                $office_id = $department_has_office->office_id;

                // Check if department has divisions
                $department_has_division = Division::where('department_id', $employee_meta_info->department_id)->first();
                if ($department_has_division) {
                    $office_id = $department_has_division->department->office_id;

                     // Check if division has section
                    $division_has_section = Section::where('division_id', $employee_meta_info->division_id)->first();
                    if ($division_has_section) {
                        $office_id = $division_has_section->division->department->office_id;

                        // Check if section has unit
                        $section_has_unit = Unit::where('section_id', $division_has_section->id)->first();
                        if ($section_has_unit) {
                            $office_id = $section_has_unit->section->division->department->office_id;
                        }
                    }
                }
            }
            return $office_id;
        }
        return null;
    }

    private static function get_percentage_by_office($office_id) { // 1 - Core | 2 - Strategic | 3 - Support
        $percentage = [
            1 => [1 => 0.40, 2 => 0.50, 3 => 0.10], // Office of Board of Trustees
            2 => [1 => 0.40, 2 => 0.50, 3 => 0.10], // Office of the Executive Director
            3 => [1 => 0.40, 2 => 0.50, 3 => 0.10], // Office of the Deputy Executive Director for Medical Services
            4 => [1 => 0.40, 2 => 0.50, 3 => 0.10], // Office of the Deputy Executive Director for Nursing Services
            5 => [1 => 0.40, 2 => 0.50, 3 => 0.10], // Office of the Deputy Executive Director for Education Trainings & Research Services
            6 => [1 => 0.40, 2 => 0.50, 3 => 0.10] // Office of the Deputy Executive Director for Hospital Support Services
        ];

        return $percentage[$office_id] ?? [1 => 0.70, 2 => 0, 3 => 0.30];
    }

}
