<?php

namespace Suiterus\Adg\Services\Reports;
use SoareCostin\FileVault\Facades\FileVault;
use Illuminate\Support\Facades\Storage;
class SalnReportService{

    public function updateCreateSalnReports ($purpose, $id, $salnReport, $user_id, $net_worth, $justification, $attachments, $status)
    {
        /* The `if($purpose == 'update/create'){` condition is checking if the value of the ``
        variable is equal to `'update/create'`. If it is, then the code inside this condition will
        be executed. */
        if($purpose == 'update/create'){
        
            $filePath = Storage::disk('saln_attachment')->put($user_id, $attachments);
            FileVault::disk('saln_attachment')->encrypt($filePath);

            $salnReport->fill([
                'user_id' => $user_id,
                'net_worth' => $net_worth,
                'justification' => $justification,
                'attachment' => $filePath,
                'status' => $status,
                'updated_at' => now(),
            ]);
    
            // Set created_at only if it's a new record
            if (!$id) {
                $salnReport->created_at = now();
            }
            
            $salnReport->save();
        }

        /* The `elseif($purpose == 'approval'){` condition is checking if the value of the ``
        variable is equal to `'approval'`. If it is, then the code inside this condition will be
        executed. */
        elseif($purpose == 'approval'){

            $salnReport->fill([
                'user_id' => $user_id,
                'justification' => $justification,
                'status' => $status,
                'updated_at' => now(),
            ]);
    
            $salnReport->save();
        }

    }


}
