<?php

namespace Suiterus\Adg\Services;

use App\Enums\ReportType;

class ReportService {

    public function getFileTemplate($reportType){

        switch($reportType) {
            case ReportType::GSIS:
                $path = 'report-template/GSIS-Contirbution-Loan-Report-Template.xlsx';
                break;
            case ReportType::PAGIBIG:
                $path = 'report-template/PagIbig-Contribution-Report-Template.xlsx';
                break;
            case ReportType::PAGIBIG_LOAN:
                $path = 'report-template/PagIbig-Loan-Report-Template.xlsx';
                break;
            case ReportType::PHILHEALTH:
                $path = 'report-template/Philhealth-Contribution-Report-Template.xlsx';
                break;
            case ReportType::WITHOLDING_TAX:
                $path = 'report-template/Withholding-Tax-Report-Template.xlsx';
                break;
            case ReportType::SALN:
                $path = 'report-template/Saln-Report-Template.xlsx';
                break;
            case ReportType::DAILY_RATE:
                $path = 'report-template/rate-per-day.xlsx';
                break;
            case ReportType::HIRED_EMPLOYEE:
                $path = 'report-template/Hired-Employee-Report-Template.xlsx';
                break;
            case ReportType::RESIGNED_EMPLOYEE:
                $path = 'report-template/Resigned-Employee-Report-Template.xlsx';
                break;
            case ReportType::OTHER_INCOME_DEDUCTIONS:
                $path = 'report-template/Other-Income-Deduction-Report-Template.xlsx';
                break;
            case ReportType::RATA:
                $path = 'report-template/RATA-Monthly-Report-Template.xlsx';
                break;
            case ReportType::THIRTEENTH_MONTH:
                $path = 'report-template/13th-Month-Pay-Report-Template.xlsx';
                break;    
            default:
                $path = null;
        }

        return $path;
    }
}
