<?php

namespace Suiterus\Adg\Services\Payroll;
use Carbon\Carbon;
use App\Enums\Status;
use App\Enums\HolidayPurpose;
use App\Enums\LeaveWithoutPay;
use Illuminate\Support\Facades\Log;
use Suiterus\Adg\Models\SM\Holiday;
use Illuminate\Support\Facades\Auth;
use App\Models\PayrollEmployeeLeaveHistory;
use Suiterus\Adg\Models\Payroll\LeaveRefund;
use Suiterus\Adg\Models\Timekeeping\Attendance;
use Suiterus\Adg\Models\Payroll\LeaveRefundDetails;
use Suiterus\Adg\Models\LeaveManagement\LeaveCreditHistory;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveBalance;
use Suiterus\Adg\Controllers\Payroll\Generator\PayrollGenerator;
use Suiterus\Adg\Models\Payroll\PayrollEarningDeduction;

class PayrollService{

    /*
    TODO: Transfer functions from PayrollGenerator to PayrollService in regards to refactoring the payroll generation
    NOTE: @jpamedo started the compute_holiday but will push in another pr when ticket is filed
    */
    public function compute_lwop()
    {

    }

    public function compute_deductions()
    {

    }

    public function get_computed_loans()
    {

    }

    public function compute_holiday()
    {
       
    }

    public function compute_overttime()
    {

    }

    public function compute_hazard_pay()
    {

    }

    public function compute_longevity_pay()
    {

    }

    public function get_allowances()
    {

    }
    //Private function for compiling holiday collection reconciled with user attendance
    private function compile_holiday()
    {
        
    }

    /**
     * The function deducts leave balance for payroll employees based on their timekeeping deductions
     * and updates the leave balance accordingly.
     * 
     * @param payroll_employees An array of payroll employees. Each employee should have a user_id
     * property.
     * @param period_start The "period_start" parameter represents the start date of the payroll
     * period for which the leave balance deduction is being calculated.
     * @param period_end The "period_end" parameter represents the end date of the payroll period for
     * which the leave balance deduction is being calculated.
     */
    public function deduct_leave_balance($payroll_employees, $period_start, $period_end)
    {
        foreach ($payroll_employees as $employee) {
            $user_id = $employee->user_id;
            
            $total_late_minutes = $employee->timekeeping_deductions()->where('type', LeaveWithoutPay::LATE)->sum('minutes');
            $total_undertime_minutes = $employee->timekeeping_deductions()->where('type', LeaveWithoutPay::UNDERTIME)->sum('minutes');
            $total_halfday_minutes = $employee->timekeeping_deductions()->where('type', LeaveWithoutPay::HALFDAY)->sum('minutes');
            $total_absents = $employee->timekeeping_deductions()->where('type', LeaveWithoutPay::ABSENT)->count();

            $vacation_leave_balance = LeaveBalance::where('user_id', $user_id)->where('leave_type_id', '1')->first();
            $sick_leave_balance = LeaveBalance::where('user_id', $user_id)->where('leave_type_id', '2')->first();

            $old_vl_balance = $vacation_leave_balance->balance;
            $old_sl_balance = $sick_leave_balance->balance;
            
            $payroll_generator = new PayrollGenerator();
            $leaves = $payroll_generator->get_leave_deductions($employee->user, $period_start, $period_end);

            $total_lwop = $payroll_generator->get_lwop_fraction($total_late_minutes, $total_undertime_minutes, $total_halfday_minutes, $total_absents);
            $total_lwop += $leaves['total_points'];

            $vl_remaining_balance = $vacation_leave_balance->balance - $total_lwop;

            if ($vl_remaining_balance < 0) {
                $vl_remaining_balance = 0;
            }

            LeaveBalance::where('id', $vacation_leave_balance->id)->update(['balance' => $vl_remaining_balance]);
            if ($vl_remaining_balance != $old_vl_balance) {
                $vl_leave_credit_history = LeaveCreditHistory::create([
                    'user_id' => $user_id,
                    'leave_type_id' => 1,
                    'credits' => $total_lwop > $old_vl_balance ? $old_vl_balance : $total_lwop,
                    'resulting_balance' => $vl_remaining_balance,
                    'leave_adjustment_type' => 2,
                    'remarks' => 'Deduction from LWOP',
                    'period' => Carbon::now(),
                    'created_by' => Auth::id(),
                ]);

                PayrollEmployeeLeaveHistory::updateOrCreate([
                    'payroll_employee_id' => $employee->id,
                    'leave_credit_history_id' => $vl_leave_credit_history->id
                ],
                [
                    'payroll_employee_id' => $employee->id,
                    'leave_credit_history_id' => $vl_leave_credit_history->id
                ]);
            }
        }
    }

    /**
     * The function refunds the leave balance for a list of payroll employees by updating the balance
     * in the LeaveBalance table and creating a new entry in the LeaveCreditHistory table.
     * 
     * @param payroll_employees is an array of payroll employee
     * objects. Each payroll employee object represents an employee's payroll information, such as
     * their ID and user ID.
     */
    public function refund_leave_balance($payroll_employees)
    {
        foreach ($payroll_employees as $employee) {
            $payroll_employee_leave_histories = PayrollEmployeeLeaveHistory::where('payroll_employee_id', $employee->id)->get();
            $user_id = $employee->user_id;

            foreach ($payroll_employee_leave_histories as $history){
                $credit = $history->leaveCreditHistory->credits;
                $leave_type_id = $history->leaveCreditHistory->leave_type_id;
                $balance = 0;

                $latest_balance = LeaveBalance::where([
                    ['user_id', $user_id], ['leave_type_id', $leave_type_id]
                ])->first();

                $get_latest_balance = $latest_balance->balance;

                $balance = $credit + $get_latest_balance;

                LeaveBalance::where([
                    ['user_id', $user_id], ['leave_type_id', $leave_type_id]
                ])->update(['balance' => $balance]);

                LeaveCreditHistory::create([
                    'user_id' => $user_id,
                    'leave_type_id' => $leave_type_id,
                    'credits' => $credit,
                    'resulting_balance' => $balance,
                    'leave_adjustment_type' => 1,
                    'remarks' => 'Refunded from LWOP',
                    'period' => Carbon::now(),
                    'created_by' => Auth::id(),
                ]);
            }
            PayrollEmployeeLeaveHistory::where('payroll_employee_id', $employee->id)->delete();
        }
    }

    public function refund_leave_balance_v2($payroll_employees)
    {
        foreach ($payroll_employees as $employee) {
            $user_id = $employee->user_id;
            $credit = 0;
            $approved = 1;
            $refunded = 4;
            $voided = 5;
            $vacation_leave = 1;

            $refunds = LeaveRefund::where('user_id', $user_id)
            ->whereIn('status', [$approved, $voided])->get();

            foreach ($refunds as $refund) {
                if ($refund) {
                    $credit += $refund->total_credits;
                    $refund->update([
                        'status' => $refunded
                    ]);
                }
            }

            if ($credit > 0) {
                $has_balance = LeaveBalance::where([
                    ['user_id', $user_id], ['leave_type_id', $vacation_leave]
                ])->first();

                if ($has_balance) {
                    $balance = $credit + $has_balance->balance;

                    LeaveBalance::where([
                        ['user_id', $user_id], ['leave_type_id', $vacation_leave]
                    ])->update(['balance' => $balance]);

                    LeaveCreditHistory::create([
                        'user_id' => $user_id,
                        'leave_type_id' => $vacation_leave,
                        'credits' => $credit,
                        'resulting_balance' => $balance,
                        'leave_adjustment_type' => 1,
                        'remarks' => 'Refund from last payroll cut-off',
                        'period' => Carbon::now(),
                        'created_by' => Auth::id(),
                    ]);
                }
            }
        }
    }
    

    public function deduct_leave_balance_v2($payroll_employees)
    {
        foreach ($payroll_employees as $employee) {
            $user_id = $employee->user_id;
            $credit = 0;
            $refunded = 4;
            $voided = 5;
            $vacation_leave = 1;

            $refunds = LeaveRefund::where([
                ['status', $refunded], ['user_id', $user_id]
            ])->get();

            foreach ($refunds as $refund) {
                if ($refund) {
                    $credit += $refund->total_credits;
                    $refund->update([
                        'status' => $voided,
                    ]);
                }
            }

            if ($credit > 0) {
                $latest_balance = LeaveBalance::where([
                        ['user_id', $user_id], ['leave_type_id', $vacation_leave]
                ])->first();

                if ($latest_balance) {
                    $balance = $latest_balance->balance - $credit;

                    LeaveBalance::where([
                        ['user_id', $user_id], ['leave_type_id', $vacation_leave]
                    ])->update(['balance' => $balance]);

                    LeaveCreditHistory::create([
                        'user_id' => $user_id,
                        'leave_type_id' => $vacation_leave,
                        'credits' => $credit,
                        'resulting_balance' => $balance < 0 ? 0 : $balance,
                        'leave_adjustment_type' => 2,
                        'remarks' => 'Refund from last cut-off was voided.',
                        'period' => Carbon::now(),
                        'created_by' => Auth::id(),
                    ]);
                }   
            }
        }
    }
}