<?php

namespace Suiterus\Adg\Services\PDS;

use Suiterus\Adg\Models\EMI\EmployeeExtraFieldGroup;

class PDSEmployeeService
{
    public function determineGroup($tableName, ?int $userId) {
        $group = null;
        if ($tableName == 'personal_information' || $tableName == 'pds_choices' || $tableName == 'other_information') {
            $groupName = 'personal_information';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'residential_address' || $tableName == 'permanent_address') {
            $groupName = 'address';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'spouse' || $tableName == 'children' || $tableName == 'father' || $tableName == 'maiden_name') {
            $groupName = 'family_background';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'elementary' || $tableName == 'secondary' || $tableName == 'vocational' || $tableName == 'college' || $tableName == 'graduate') {
            $groupName = 'educational_background';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'civil_services') {
            $groupName = 'civil_services';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'work_experience') {
            $groupName = 'work_experience';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'voluntary_work') {
            $groupName = 'voluntary_work';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'learning_development') {
            $groupName = 'learning_development';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'skills_hobbies') {
            $groupName = 'skills_hobbies';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'choices') {
            $groupName ='choices';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'reference') {
            $groupName ='references';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'government_id') {
            $groupName ='government_id';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else if ($tableName == 'file_attachments') {
            $groupName ='file_attachments';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        else {
            $groupName = 'others';
            $group = $this->fetchOrCreateGroup($groupName, $userId);
        }
        return $group;
    }
    public function fetchGroupId($groupName, ?int $userId) {
        $groupId = null;

        if ($groupName == 'personal_information') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'address') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'family_background') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'educational_background') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'civil_services') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'work_experience') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'voluntary_work') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'learning_development') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'skills_hobbies') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'choices') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'references') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'government_id') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else if ($groupName == 'file_attachments') {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        else {
            $group = $this->fetchGroup($groupName, $userId);
            $groupId = $group->id;
        }
        
        return $groupId;
    }

    private function fetchOrCreateGroup ($groupName, ?int $userId) {
        $group = EmployeeExtraFieldGroup::where([
            ['user_id', $userId], ['name', $groupName]
        ])->first();

        if (!$group) {
            $group = EmployeeExtraFieldGroup::create([
                'user_id' => $userId,
                'name' => $groupName,
            ]);
        }
        return $group;
    }

    private function fetchGroup ($groupName, ?int $userId) {
        $group = EmployeeExtraFieldGroup::where([
            ['user_id', $userId], ['name', $groupName]
        ])->first();

        if ($group) {
            return $group;
        }
    }

}
