<?php

namespace Suiterus\Adg\Services\OrgStructure\Unit;

use Exception;
use App\Models\User;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\ActualDesignation;

class UnitService
{
    public function assignHeadEmployee($employeeId, $unitId)
    {

        $unit = Unit::find($unitId);

        if (!$unit) {
            throw new Exception('No unit found');
        }

        $section = $unit->section;

        if (!$section) {
            throw new Exception('No section found');
        }

        $division = $section->division;

        if (!$division) {
            throw new Exception('No division found');
        }

        $department = $division->department;

        if (!$department) {
            throw new Exception('No department found');
        }

        $office = $department->office;

        if (!$office) {
            throw new Exception('No office found');
        }

        return Unit::where('id', $unitId)->update([
            'head_employee_id' => $employeeId
        ]);
    }

    public function assignEmployeeUnit($employeeId, $unitId)
    {
        $unit = Unit::find($unitId);

        if (!$unit) {
            throw new Exception('No unit found');
        }

        $unitSection = null;
        $unitDivision = null;
        $unitDept = null;
        $unitOffice = null;

        if ($unit->section) {
            $unitSection = $unit->section;
            $unitDivision = $unitSection->division;
            $unitDept = $unitDivision->department;
            $unitOffice = $unitDept->office;
        }else if($unit->division)  {
            $unitDivision = $unit->division;
            $unitDept = $unitDivision->department;
            $unitOffice = $unitDept->office;
        }else if ($unit->department) {
            $unitDept = $unit->department;
            $unitOffice = $unitDept->office;
        }else if ($unit->office) {
            $unitOffice = $unit->office;
        }

        if (!$unitSection && !$unitDept && !$unitOffice && !$unitDivision) {
            throw new Exception('A unit must have at least 1 section, division, department and office');
        }

        return ActualDesignation::updateOrCreate(
            [
                'user_id' => $employeeId
            ],
            [
                'office_id' => $unitOffice ? $unitOffice->id : null,
                'department_id' => $unitDept ? $unitDept->id : null,
                'division_id' => $unitDivision ? $unitDivision->id : null,
                'section_id' => $unitSection ? $unitSection->id : null,
                'unit_id' => $unitId
            ]
        );
    }

    public function getEmployees($unitId)
    {
        return User::whereHas('actualDesignation', function ($query) use ($unitId) {
            $query->where('unit_id', $unitId);
        })->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ])->get();
    }
}
