<?php

namespace Suiterus\Adg\Services\OrgStructure\Section;

use Exception;
use App\Models\User;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\ActualDesignation;

class SectionService
{
    public function assignHeadEmployee($employeeId, $sectionId)
    {

        $section = Section::find($sectionId);

        if (!$section) {
            throw new Exception('No section found');
        }

        $division = $section->division;

        if (!$division) {
            throw new Exception('No division found');
        }

        $department = $division->department;

        if (!$department) {
            throw new Exception('No department found');
        }

        $office = $department->office;

        if (!$office) {
            throw new Exception('No office found');
        }

        return Section::where('id', $sectionId)->update([
            'head_employee_id' => $employeeId
        ]);
    }

    public function assignEmployeeSection($employeeId, $sectionId)
    {
        $section = Section::find($sectionId);

        if (!$section) {
            throw new Exception('No section found');
        }

        $division = $section->division;

        if (!$division) {
            throw new Exception('No division found');
        }

        $department = $division->department;

        if (!$department) {
            throw new Exception('No department found');
        }

        $office = $department->office;

        if (!$office) {
            throw new Exception('No office found');
        }

        return ActualDesignation::updateOrCreate(
            ['user_id' => $employeeId],
            [
                'office_id' => $office->id,
                'department_id' => $department->id,
                'division_id' => $division->id,
                'section_id' => $sectionId,
                'unit_id' => null
            ]
        );
    }

    public function assignUnits(?array $unitIds, Section $section)
    {
        foreach ($unitIds as $unitId) {
            Unit::whereId($unitId)->update([
                'section_id' => $section->id,
                'office_id' => null,
                'department_id' => null,
                'division_id' => null
            ]);
        }

        return $this;
    }

    public function getEmployees($sectionId)
    {
        $unitIds = Unit::select('id')->whereIn('section_id', $sectionId)->get()->toArray();

        return User::whereHas('actualDesignation', function ($query) use ($sectionId, $unitIds) {
            $query->where('section_id', $sectionId)->orWhereIn('unit_id', $unitIds);
        })->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ])->get();
    }
}
