<?php

namespace Suiterus\Adg\Services\OrgStructure\Division;

use Exception;
use App\Models\User;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\ActualDesignation;

class DivisionService
{

    public function assignHeadEmployee($employeeId, $divisionId)
    {

        $division = Division::find($divisionId);

        if (!$division) {
            throw new Exception('No division found');
        }

        $divisionDept = null;
        $divisionOffice = null;

        if ($division->department) {
            $divisionDept = $division->department;
            $divisionOffice = $divisionDept->office;
        }else if($division->office) {
            $divisionOffice = $division->office;
        }

        if (!$divisionDept && !$divisionOffice) {
            throw new Exception('Division is not assigned to any office or department');
        }

        return Division::where('id', $divisionId)->update([
            'head_employee_id' => $employeeId
        ]);
    }

    public function assignEmployeeDivision($userIds, $divisionId)
    {
        $division = Division::find($divisionId);

        if (!$division) {
            throw new Exception('No division found');
        }

        $divisionDept = null;
        $divisionOffice = null;

        if ($division->department) {
            $divisionDept = $division->department;
            $divisionOffice = $divisionDept->office;
        }else if($division->office) {
            $divisionOffice = $division->office;
        }

        if (!$divisionDept && !$divisionOffice) {
            throw new Exception('Division is not assigned to any office or department');
        }

        foreach ($userIds as $userId) {
            ActualDesignation::updateOrCreate(
                ['user_id' => $userId],
                [
                    'office_id' => $divisionOffice ? $divisionOffice->id : null,
                    'department_id' => $divisionDept ? $divisionDept->id : null,
                    'division_id' => $divisionId,
                    'section_id' => null,
                    'unit_id' => null
                ]
            );
        }
        return $this;
    }

    public function assignUnits(array $unitIds, Division $division)
    {
        foreach ($unitIds as $unitId) {
            Unit::whereId($unitId)->update([
                'section_id' => null,
                'office_id' => null,
                'department_id' => null,
                'division_id' => $division->id
            ]);
        }
        return $this;
    }

    public function getEmployees($divisionId)
    {
        $sectionIds = Section::select('id')->whereIn('division_id', $divisionId)->get()->toArray();

        $unitIds = Unit::select('id')->whereIn('section_id', $sectionIds)->get()->toArray();

        return User::whereHas('actualDesignation', function ($query) use ($divisionId, $sectionIds, $unitIds) {
            $query->where('division_id', $divisionId)->orWhereIn('section_id', $sectionIds)->orWhereIn('unit_id', $unitIds);
        })->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ])->get();
    }
}
