<?php

namespace Suiterus\Adg\Services\OrgStructure\Department;

use Exception;
use App\Models\User;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\ActualDesignation;

class DepartmentService
{

    public function assignHeadEmployee($employeeId, $departmentId)
    {

        $department = Department::find($departmentId);

        if (!$department) {
            throw new Exception('No department found');
        }

        $office = $department->office;

        if (!$office) {
            throw new Exception('No office found');
        }

        return Department::where('id', $departmentId)->update([
            'head_employee_id' => $employeeId
        ]);
    }

    public function assignEmployeeDepartment($employeeId, $departmentId)
    {
        $department = Department::find($departmentId);

        if (!$department) {
            throw new Exception('No department found');
        }

        $office = $department->office;

        if (!$office) {
            throw new Exception('No office found');
        }

        return ActualDesignation::updateOrCreate(
            [
                'user_id' => $employeeId,
            ],
            [
                'office_id' => $office->id,
                'department_id' => $departmentId,
                'division_id' => null,
                'section_id' => null,
                'unit_id' => null,
            ]
        );
    }

    public function assignUnits(?array $unitIds, Department $department)
    {
        foreach ($unitIds as $unitId) {
            Unit::whereId($unitId)->update([
                'section_id' => null,
                'office_id' => null,
                'department_id' => $department->id,
                'division_id' => null
            ]);
        }

        return $this;
    }

    public function getEmployees($departmentId)
    {

        $divisionsIds = Division::select('id')->where('department_id', $departmentId)->get()->toArray();

        $sectionIds = Section::select('id')->whereIn('division_id', $divisionsIds)->get()->toArray();

        $unitIds = Unit::select('id')->whereIn('section_id', $sectionIds)->get()->toArray();

        return User::whereHas('actualDesignation', function ($query) use ($departmentId, $divisionsIds, $sectionIds, $unitIds) {
            $query->where('department_id', $departmentId)->orWhereIn('division_id', $divisionsIds)->orWhereIn('section_id', $sectionIds)->orWhereIn('unit_id', $unitIds);
        })->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ])->get();
    }
}
