<?php

namespace Suiterus\Adg\Services\Mentorship;

use Carbon\Carbon;
use App\Enums\Mentorship\MentorshipInviteStatus;
use Suiterus\Adg\Models\Mentorship\MentorshipDate;
use Suiterus\Adg\Models\Mentorship\MentorshipInvite;
use Suiterus\Adg\Models\Mentorship\MentorshipMentor;
use Suiterus\Adg\Models\Mentorship\MentorshipSession;
use Suiterus\Adg\Models\Mentorship\MentorshipAttachment;

class MentorshipService 
{
    public function addDate($programVenue, $startDate, $endDate, $startTime, $endTime, MentorshipSession $session) 
    {
            $startDate = Carbon::parse($startDate);
            $endDate = Carbon::parse($endDate);
    
            while ($startDate <= $endDate) {
                $startTime = Carbon::parse($startTime)->format('H:i');
                $endTime = Carbon::parse($endTime)->format('H:i');
                
                MentorshipDate::create([
                    'session_id' => $session->id,
                    'date' => $startDate->format('Y-m-d'),
                    'start_time' => $startTime,
                    'end_time' => $endTime,
                    'program_venue' => $programVenue,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]);
                $startDate->addDay();
            }
    }

    public function addMentor($mentor, MentorshipSession $session)
    {
        MentorshipMentor::create([
            'session_id' => $session->id,
            'mentor_id' => $mentor,
            'status' => MentorshipInviteStatus::PENDING,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
        
    }

    public function addMentee($mentee, MentorshipSession $session)
    {
        MentorshipInvite::create([
            'session_id' => $session->id,
            'mentee_id' => $mentee,
            'status' => MentorshipInviteStatus::PENDING,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
    }

    public function addAttachment($attachment, MentorshipSession $session)
    {
        $path = $attachment->storeAs($session->mentorship_id, $attachment->getClientOriginalName(), 'mentorship_attachment');
        MentorshipAttachment::create([
            'session_id' => $session->id,
            'file_name' => $attachment->getClientOriginalName(),
            'file_path' => $path,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
    }

    public function deleteMentorshipDate(MentorshipSession $session)
    {
        $session->dates()->delete();

    }
}
