<?php

namespace Suiterus\Adg\Services\EmployeeTypeHistory;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Adg\Models\EMI\AppointmentForm;

class DownloadAppointmentFormRequest extends FormRequest {


    public function authorize(): bool
    {

        $appointmentForm = AppointmentForm::where('file_path', $this->path)->first();

        if (!$appointmentForm) {
            return false;
        }

        return $appointmentForm->employeeTypeHistory->user_id == Auth::id();
    }

    public function rules(): array
    {
        return [
            'path'  =>  'required|exists:' . env('ADG_DB_CONNECTION') . '.appointment_forms,file_path'
        ];
    }

}
