<?php

namespace Suiterus\Adg\Services\Contribution;

use App\Enums\Status;
use App\Enums\ContributionType;
use Suiterus\Adg\Models\SM\Contribution; 
use Suiterus\Adg\Contracts\Contribution\ContributionCalculator;

class PhilHealthContributionCalculatorService implements ContributionCalculator
{

    /**
     * The function computes the personal and government shares based on the given basic salary.
     * @param float basicSalary The basicSalary parameter is the base salary of an employee.
     * @return array with two key-value pairs. The first key is 'personal_share' and the value is
     * the result of multiplying the basicSalary by 0.02. The second key is 'government_share' and the
     * value is also the result of multiplying the basicSalary by 0.02.
     */
    public function compute($user, float $basicSalary = 0.00, $date)
    {
        $philhealth = Contribution::where('type', ContributionType::PHILHEALTH)->whereDate('effectivity_date' , '<=', $date)->first();
        $rate  = $philhealth->employee_share / 100;
        $share  = $basicSalary * $rate; // 0.02 percentage of sharing to the basic salary,
        $share = $share > 900 ? 900 : $share;
        return [
            'personal_share' => $share,
            'government_share' => $share
        ];
    }
}
