<?php

namespace Suiterus\Adg\Services\Contribution;

use App\Enums\Status;
use App\Enums\ContributionType;
use Suiterus\Adg\Models\SM\Contribution; 
use Suiterus\Adg\Models\SM\EmployeeContribution; 
use Suiterus\Adg\Contracts\Contribution\ContributionCalculator;

class PagibigContributionCalculatorService implements ContributionCalculator
{

    /**
     * The function computes the contribution amount based on the given basic salary, with a maximum
     * contribution of 100.
     * @param float basicSalary The basicSalary parameter is a float value representing the employee's
     * basic salary.
     * @return the value of the variable contribution.
     */
    public function compute($user, float $basicSalary = 0.00, $date)
    {
        $pagibig = Contribution::where('type', ContributionType::PAGIBIG)->whereDate('effectivity_date', '<=', $date)->first();
        $amount = EmployeeContribution::where('contribution_id', $pagibig->id)->where('user_id', $user)->value('amount');
        $savings_rate = $pagibig->savings_rate;

        if($amount) {
            $personalShare = $amount;
        }else {
            $personalRate = $pagibig->employee_share / 100;
            $personalContribution = $basicSalary * $personalRate;
            $personalShare = $personalContribution > $savings_rate ? $savings_rate : $personalContribution;
        }        

        $governmentRate = $pagibig->company_share / 100;
        $governmentContribution = $basicSalary * $governmentRate;
        $governmentShare = $governmentContribution > $savings_rate ? $savings_rate : $governmentContribution;

        return  [
            'personal_share' => $personalShare,
            'government_share' => $governmentShare
        ];

    }
}
