<?php

namespace Suiterus\Adg\Services\Contribution;

use App\Enums\Status;
use App\Enums\ContributionType;
use Suiterus\Adg\Models\SM\Contribution; 
use Suiterus\Adg\Models\SM\EmployeeContribution; 
use Suiterus\Adg\Contracts\Contribution\ContributionCalculator;

class GsisContributionCalculatorService implements ContributionCalculator
{
    /**
     * The function computes the personal share, government share, and employee contribution based on
     * the given basic salary.
     * @param float basicSalary The basic salary is the base amount of money that an employee earns
     * before any deductions or bonuses are added.
     * @return array with three key-value pairs. The keys are 'personal_share', 'government_share',
     * and 'employee_contribution'. The corresponding values are the calculated values for each of
     * these variables.
     */
    public function compute($user, float $basicSalary = 0.00, $date)
    {
        $gsis = Contribution::where('type', ContributionType::GSIS)->whereDate('effectivity_date' , '<=', $date)->first();
        $emp_ecip = EmployeeContribution::where('contribution_id', $gsis->id)->where('user_id', $user)->value('ecip');

        $personalRate = $gsis->employee_share / 100;
        $personalShare = $basicSalary * $personalRate;
        $governmentRate = $gsis->company_share / 100;
        $governmentShare = $basicSalary * $governmentRate;
        
        $employeeContribution = $emp_ecip ? $emp_ecip : 0;
        
        return [
            'personal_share' => $personalShare,
            'government_share' => $governmentShare,
            'employee_contribution' => $employeeContribution
        ];
    }
}
