<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CommonController;
use Suiterus\Adg\Controllers\CSVController;
use App\Http\Controllers\ItemCodeController;
use App\Http\Controllers\COCPointsController;
use Suiterus\Adg\Controllers\Payroll\LeaveRefundController;
use Suiterus\Adg\Models\SM\OfficePerEmployee;
use Suiterus\Adg\Controllers\PDS\PDSController;
use Suiterus\Adg\Controllers\SettingController;
use Suiterus\Adg\Controllers\SM\LoanController;
use Suiterus\Adg\Controllers\SM\ShiftController;
use Suiterus\Adg\Controllers\SM\UnitsController;
use Suiterus\Adg\Controllers\SPMS\MfoController;
use Suiterus\Adg\Controllers\SM\RemarkController;
use Suiterus\Adg\Controllers\SM\HolidayController;
use Suiterus\Adg\Controllers\SM\OfficesController;
use Suiterus\Adg\Controllers\SM\SectionsController;
use Suiterus\Adg\Controllers\SM\AllowanceController;
use Suiterus\Adg\Controllers\SM\LongevityController;
use Suiterus\Adg\Controllers\SPMS\PCRFormController;
use Suiterus\Adg\Controllers\Approvals\CTOController;
use Suiterus\Adg\Controllers\Loan\UserLoanController;
use Suiterus\Adg\Controllers\SM\SpecialPayController;
use Suiterus\Adg\Controllers\SM\SuspensionController;
use Suiterus\Adg\Controllers\SM\HolidayTypeController;
use Suiterus\Adg\Controllers\SM\RosterGroupController;
use Suiterus\Adg\Controllers\SM\SalaryGradeController;
use Suiterus\Adg\Controllers\Biometrics\SyncController;
use Suiterus\Adg\Controllers\Payroll\PayrollController;
use Suiterus\Adg\Controllers\Payslip\PayslipController;
use Suiterus\Adg\Controllers\Reports\ReportsController;
use Suiterus\Adg\Controllers\SM\ContributionController;
use Suiterus\Adg\Controllers\SM\EmployeeTypeController;
use Suiterus\Adg\Controllers\SM\RosterLegendController;
use Suiterus\Adg\Controllers\SM\ScheduleTypeController;
use Suiterus\Adg\Controllers\SM\TrainingTypeController;
use Suiterus\Adg\Controllers\Timekeeping\DTRController;
use Suiterus\Adg\Controllers\SM\ScheduleTitleController;
use Suiterus\Adg\Controllers\SPMS\PCRFormTypeController;
use Suiterus\Adg\Controllers\SPMS\UserPcrFormController;
use Suiterus\Adg\Controllers\Timekeeping\RFIDController;
use Suiterus\Adg\Controllers\Employee\EmployeeController;
use Suiterus\Adg\Controllers\Salary\UserSalaryController;
use Suiterus\Adg\Controllers\SM\BranchController as SM_B;
use Suiterus\Adg\Controllers\Training\TrainingController;
use Suiterus\Adg\Controllers\Approvals\OvertimeController;
use Suiterus\Adg\Controllers\PDS\PDSPerPositionController;
use Suiterus\Adg\Controllers\SM\DefaultScheduleController;
use Suiterus\Adg\Controllers\Approvals\UndertimeController;
use Suiterus\Adg\Controllers\ExitManagement\ExitController;
use Suiterus\Adg\Controllers\Promotion\PromotionController;
use Suiterus\Adg\Controllers\SM\BulkProfileRulesController;
use Suiterus\Adg\Controllers\SM\DivisionController as SM_D;
use Suiterus\Adg\Controllers\SM\PositionController as SM_P;
use Suiterus\Adg\Controllers\SM\ScheduleTemplateController;
use Suiterus\Adg\Controllers\Payroll\LongevityPayController;
use Suiterus\Adg\Controllers\SM\OfficePerEmployeeController;
use Suiterus\Adg\Controllers\SPMS\AdminEvaluationController;
use Suiterus\Adg\Controllers\Mentorship\MentorshipController;
use Suiterus\Adg\Controllers\PDS\Employee\PDSPrintController;
use Suiterus\Adg\Controllers\PDS\PersonalDataSheetController;
use Suiterus\Adg\Controllers\SM\DesignationHistoryController;
use Suiterus\Adg\Controllers\SPMS\BalanceScoreCardController;
use Suiterus\Adg\Controllers\SPMS\MetricEvaluationController;
use Suiterus\Adg\Controllers\Timekeeping\TimetableController;
use Suiterus\Adg\Controllers\Training\UserTrainingController;
use App\Http\Controllers\Auth\UserController as UsrController;
use Suiterus\Adg\Controllers\Promotion\SupplementalController;
use Suiterus\Adg\Controllers\Reports\AbsenceRerportController;
use Suiterus\Adg\Controllers\SM\CorporationController as SM_C;
use Suiterus\Adg\Controllers\SM\DepartmentController as SM_DD;
use Suiterus\Adg\Controllers\SM\SpecialPayFrequencyController;
use Suiterus\Adg\Controllers\SPMS\PCRFormPermissionController;
use Suiterus\Adg\Controllers\Timekeeping\AttendanceController;
use Suiterus\Adg\Controllers\Timekeeping\BiometricsController;
use Suiterus\Adg\Controllers\PDS\PDSPrintPerPositionController;
use Suiterus\Adg\Controllers\SPMS\EmployeeEvaluationController;
use Suiterus\Adg\Controllers\Approvals\OvertimeReportController;
use Suiterus\Adg\Controllers\Biometrics\BiometricSyncController;
use Suiterus\Adg\Controllers\ExitManagement\ClearanceController;
use Suiterus\Adg\Controllers\PDS\Employee\PDSEmployeeController;
use Suiterus\Adg\Controllers\SM\SalaryStandardizationController;
use Suiterus\Adg\Controllers\LearningDevelopment\MeritController;
use Suiterus\Adg\Controllers\LeaveManagement\LeaveTypeController;
use Suiterus\Adg\Controllers\Timekeeping\Roster\RosterController;
use Suiterus\Dms\Controllers\AccessManagement\UserTypeController;
use Suiterus\Adg\Controllers\Approvals\TrainingApprovalController;
use Suiterus\Adg\Controllers\Biometrics\BiometricDeviceController;
use Suiterus\Adg\Controllers\EmployeeCases\EmployeeCaseController;
use Suiterus\Adg\Controllers\Loan\Employee\LoanEmployeeController;
use Suiterus\Adg\Controllers\Biometrics\DeviceConnectionController;
use Suiterus\Adg\Controllers\LearningDevelopment\DemeritController;
use Suiterus\Adg\Controllers\LeaveManagement\LeaveCreditController;
use Suiterus\Adg\Controllers\Mentorship\MentorshipInviteController;
use Suiterus\Adg\Controllers\Mentorship\MentorshipMentorController;
use Suiterus\Adg\Controllers\Mentorship\MentorshipReportController;
use Suiterus\Adg\Controllers\Reports\EmployeeSalnReportsController;
use Suiterus\Dms\Controllers\AccessManagement\PermissionController;
use Suiterus\Adg\Controllers\Employee\DownloadUploadAppointmentForm;
use Suiterus\Adg\Controllers\Employee\EmployeeTypeHistoryController;
use Suiterus\Adg\Controllers\LeaveManagement\LeaveBalanceController;
use Suiterus\Adg\Controllers\Mentorship\MentorshipSessionController;
use Suiterus\Adg\Controllers\SPMS\MetricEvaluationHistoryController;
use Suiterus\Adg\Controllers\SPMS\PerformanceRatingReportController;
use Suiterus\Adg\Controllers\Timekeeping\EmployeeScheduleController;
use Suiterus\Adg\Controllers\LeaveManagement\LeaveApproverController;
use Suiterus\Adg\Controllers\LeaveManagement\LeaveEligibleController;
use Suiterus\Adg\Controllers\SuccessionManagement\SuccessorController;
use Suiterus\Adg\Controllers\Mentorship\MentorshipAttachmentController;
use Suiterus\Adg\Controllers\LearningDevelopment\TrainingBondController;
use Suiterus\Adg\Controllers\LeaveManagement\LeaveApplicationController;
use Suiterus\Adg\Controllers\Reports\TalentAcquisitionReportsController;
use App\Http\Controllers\AccessManagement\GroupManagement\RoleController;
use App\Http\Controllers\AccessManagement\GroupManagement\UserController;
use Suiterus\Adg\Controllers\Approvals\Employee\CTOApplicationController;
use Suiterus\Adg\Controllers\Timekeeping\Roster\RosterTemplateController;
use Suiterus\Adg\Controllers\UserSupervisors\SupervisorsController as SC;
use App\Http\Controllers\AccessManagement\GroupManagement\SystemController;
use Suiterus\Adg\Controllers\Promotion\Employee\PromotionController as PCE;
use Suiterus\Adg\Controllers\Timekeeping\Roster\RosterRescheduleController;
use App\Http\Controllers\AccessManagement\GroupManagement\SubRoleController;
use Suiterus\Adg\Controllers\ExitManagement\Employee\ClearanceFormController;
use Suiterus\Adg\Controllers\SuccessionManagement\CriticalPositionController;
use Suiterus\Adg\Controllers\UserSupervisors\UserSupervisorController as USC;
use Suiterus\Adg\Controllers\Approvals\Employee\UserOvertimeController as UOC;
use App\Http\Controllers\AccessManagement\GroupManagement\RoleLeaderController;
use Suiterus\Adg\Controllers\Approvals\Employee\UserUndertimeController as UUC;
use App\Http\Controllers\AccessManagement\GroupManagement\ModelHasRoleController;
use App\Http\Controllers\AccessManagement\GroupManagement\SystemModuleController;
use Suiterus\Adg\Controllers\Salary\AllowanceAndPays\EmployeeAllowanceController;
use App\Http\Controllers\AccessManagement\GroupManagement\RoleHasSystemController;
use App\Http\Controllers\AccessManagement\GroupManagement\SubRoleModuleController;
use Suiterus\Adg\Controllers\Salary\AllowanceAndPays\EmployeeSpecialPayController;
use Suiterus\Adg\Controllers\Timekeeping\Roster\Employee\RosterEmployeeController;
use Suiterus\Adg\Controllers\Reports\TalentAcquisition\TimeToHireReportsController;
use App\Http\Controllers\AccessManagement\GroupManagement\RoleSystemModuleController;
use Suiterus\Adg\Controllers\ExitManagement\ExitInterview\ExitInterviewController as EI;
use Suiterus\Adg\Controllers\Reports\TalentAcquisition\NewHireTurnoverReportsController;
use Suiterus\Adg\Controllers\LeaveManagement\Employee\LeaveController as EmployeeLeaveController;
use Suiterus\Adg\Controllers\SM\NightDifferentialPayController;
use Suiterus\Adg\Controllers\Timekeeping\Employee\AttendanceController as EmployeeAttendanceController;

//API for SRIT or other system that uses middleware API key
Route::group(['prefix' => 'api', 'middleware' => ['auth.apikey']], function() {
    Route::group(['prefix' => 'v1'], function() {
        Route::group(['prefix' => 'employee'], function(){

            Route::get('paginate', [UsrController::class, 'paginate']);

            Route::get('/', [UsrController::class, 'index']);
            Route::get('/{user_id}', [UsrController::class, 'show']);
            Route::get('fetch/service-records', [UsrController::class, 'fetchEmployeeWithServiceRecords']);

        });
    });
});

Route::group(['prefix' => 'api', 'middleware' => 'auth:api'], function () {

    // Version 2 of Removing Head Employee and Employee Roster Shift
    Route::prefix('v2')->group(function () {
        Route::prefix('roster')->group(function () {

            Route::post('employee-shift', [RosterController::class, 'get_users_shift']);

            Route::get('/', [RosterController::class, 'index']);

            Route::get('{roster_id}/groups', [RosterController::class, 'get_groups']);

            Route::patch('assign-head-employee', [RosterController::class, 'assign_head_employee']);
            Route::patch('remove-head-employee', [RosterController::class, 'remove_head_employee']);

            Route::prefix('template')->group(function () {
                Route::post('paginate', [RosterTemplateController::class, 'paginate'])->middleware('permission:can paginate roster template');
                Route::delete('{roster_template_id}', [RosterTemplateController::class, 'destroy'])->middleware('permission:can delete roster template');
                Route::get('/', [RosterTemplateController::class, 'index'])->middleware('permission:can list roster template');
                Route::post('/', [RosterTemplateController::class, 'store'])->middleware('permission:can create roster template');
                Route::post('apply', [RosterTemplateController::class, 'applyTemplate'])->middleware('permission:can create roster from template');
            });
            Route::prefix('group')->group(function () {
                Route::post('/', [RosterGroupController::class, 'store']);
                Route::post('assign-employee', [RosterGroupController::class, 'assign_employee']);
                Route::post('transfer-employee', [RosterGroupController::class, 'transfer_employee']);
            });
        });
        Route::prefix('remove')->group(function () {
            Route::put('head_employee_shift', [RosterController::class, 'delete_head_employee_shift'])->middleware('permission:can assign roster schedule shift');
            Route::put('employee_shift', [RosterController::class, 'delete_employee_shift'])->middleware('permission:can assign roster schedule shift');
        });



        Route::group(['prefix' => 'spms'], function () {

            Route::group(['prefix' => 'admin'], function () {
                Route::middleware('module:SPMS - Dashboard')->group(function () {
                    Route::get('evaluation-score', [AdminEvaluationController::class, 'getEvaluationScore']);
                    Route::get('evaluation-score-by-office', [PerformanceRatingReportController::class, 'getEvaluationScoreByOffice']);
                });

                Route::middleware('module:Performance Rating Report')->group(function () {
                    Route::get('paginate-performance-rating-report', [PerformanceRatingReportController::class, 'paginatePerformanceRatingReport']);
                    Route::post('upload-performance-rating-file', [PerformanceRatingReportController::class, 'updateReportFilePath']);
                    Route::get('download-performance-rating-file', [PerformanceRatingReportController::class, 'downloadPerformanceReport']);
                });

                Route::group(['prefix' => 'pcr'], function () {

                    Route::get('/', [PCRFormTypeController::class, 'index'])->middleware('module:Configure|Organization Structure');

                    Route::middleware('module:Configure')->group(function () {
                        Route::post('paginate-by-user', [UserPcrFormController::class, 'paginateByUser']);
                        Route::get('employees-with-pcr', [UserPcrFormController::class, 'getEmployeesWithPCR']);
                        Route::get('employees-without-pcr', [UserPcrFormController::class, 'getEmployeesWithoutPCR']);

                        Route::delete('{user_id}', [UserPcrFormController::class, 'destroy']);
                        Route::post('/', [UserPcrFormController::class, 'store']);
                    });
                });

                Route::group(['prefix' => 'mfo', 'middleware' => ['module:Configure|Organization Structure']], function () {
                    Route::get('/', [MfoController::class, 'index']);
                });

            });

            Route::group(['prefix' => 'employee'], function () {
                Route::group(['prefix' => 'pcr'], function () {
                    //insert employee pcr routes
                    Route::get('{user_id}', [UserPcrFormController::class, 'getEmployeePCR'])->middleware('module:SPMS - Employee|Configure');
                });
            });
        });
    });

    //Longevity Pay
    Route::group(['prefix' => 'longevity-pay'], function () {
        Route::get('employee/{user_id}', [LongevityPayController::class, 'getEmployeeLongevityPay']);
        Route::post('pay/', [LongevityPayController::class, 'store'])->middleware('permission:can create longevity pay history');
        Route::get('pay/', [LongevityPayController::class, 'index'])->middleware('permission:can paginate longevity pay history');
        Route::put('pay/{pay}', [LongevityPayController::class, 'update'])->middleware('permission:can update longevity pay history');
    });



    //coaching and mentoring API
    Route::post('mentorship/paginate', [MentorshipController::class, 'paginate'])->middleware('permission:can paginate mentorship');
    Route::group(['prefix' => 'mentorship-invite'], function () {
        Route::post('{mentorship_id}/list', [MentorshipInviteController::class, 'list'])->middleware('permission:can list mentorship invite');
        Route::get('paginate', [MentorshipInviteController::class, 'paginate'])->middleware('module_or_permission:Talent Management - Employee|can paginate mentorship invite');
    });

    Route::group(['prefix' => 'mentorship-mentor'], function(){
        Route::get('paginate', [MentorshipMentorController::class, 'paginate'])->middleware('module_or_permission:Talent Management - Employee|can paginate mentorship mentor');
    });

    Route::get('mentorship-attachment/download', [MentorshipAttachmentController::class, 'download'])->middleware('module_or_permission:Talent Management - Employee|permission:can download mentorship attachment');
    Route::post('mentorship', [MentorshipController::class, 'store'])->middleware('permission:can create mentorship');
    Route::put('mentorship-invite/{mentorship_invite}', [MentorshipInviteController::class, 'update'])->middleware('module_or_permission:Talent Management - Employee|can update mentorship invite');

    Route::group(['prefix' => 'mentorship-session'], function(){
        Route::post('fetch', [MentorshipSessionController::class, 'show'])->middleware('permission:can view mentorship session');
        Route::post('create', [MentorshipSessionController::class, 'store'])->middleware('permission:can create mentorship session');
        Route::post('paginate', [MentorshipSessionController::class, 'paginate'])->middleware('permission:can paginate mentorship session');
        Route::put('update/date', [MentorshipSessionController::class, 'updateMentorshipDate'])->middleware('permission:can update mentorship session');
        Route::put('update', [MentorshipSessionController::class, 'updateSession'])->middleware('permission:can update mentorship session');
    });

    Route::group(['prefix' => 'mentorship-report'], function(){
        Route::post('fetch', [MentorshipReportController::class, 'show'])->middleware('permission:can view mentorship report');
        Route::post('create', [MentorshipReportController::class, 'store'])->middleware('permission:can create mentorship report');
        Route::put('update', [MentorshipReportController::class, 'update'])->middleware('permission:can update mentorship report');

    });

    //end

    //succession management api

    Route::group(['prefix' => 'critical-position'], function () {
        Route::post('paginate', [CriticalPositionController::class, 'paginate'])->middleware('permission:can paginate critical position');
        Route::post('/', [CriticalPositionController::class, 'store'])->middleware('permission:can create critical position');
        Route::get('{critical_position_id}', [CriticalPositionController::class, 'show'])->middleware('permission:can show critical position');

        Route::group(['prefix' => 'successor'], function () {
            Route::post('paginate', [SuccessorController::class, 'paginate'])->middleware('permission:can paginate successor');
            Route::post('/', [SuccessorController::class, 'store'])->middleware('permission:can create successor');
            Route::post('promote', [SuccessorController::class, 'promote'])->middleware('permission:can promote successor');
            Route::get('{successor_id}', [SuccessorController::class, 'show'])->middleware('permission:can show successor');
        });
    });



    //end


    Route::group(['prefix' => 'pcr'], function () {
        Route::get('download-form', [PCRFormController::class, 'downloadPCRTemplate']);
        Route::post('convert-form', [PCRFormController::class, 'convertPCRToPdf']);
        Route::get('permissions', [PCRFormPermissionController::class, 'getPermissions']);
        Route::apiResource('form-types', PCRFormTypeController::class)->except(['store', 'show', 'update', 'destroy'])->middleware('role:Admin|Super Admin|Developer|HR');
    });

    Route::group(['prefix' => 'leave'], function () {
        Route::get('download-application-form', [EmployeeLeaveController::class, 'download_leave_form'])->middleware('module_or_permission:Leave - Employee|can paginate and view employee leave application');
        Route::get('download-application-attachment-form', [EmployeeLeaveController::class, 'download_leave_attachment_form'])->middleware('module_or_permission:Leave - Employee|can paginate and view employee leave application');

        Route::group(['prefix' => 'employee', 'middleware' => ['module:Leave - Employee']], function () {
            Route::get('date', [EmployeeLeaveController::class, 'fetch_leave_dates']);
        });
    });

    Route::group(['prefix' => 'office'], function () {
        Route::get('employee', [OfficePerEmployeeController::class, 'show']);
    });

    Route::group(['prefix' => 'talent-acquisition-report', ['module:Talent Acquisition Report']], function () {

        Route::group(['prefix' => 'new-hire-turnover', ['module:New Hire Turnover Rate Report']], function () {
            Route::post('paginate', [TalentAcquisitionReportsController::class, 'newHireTurnoverRatePaginate'])->middleware('permission:can paginate new hire turnover rate report');
            Route::post('show', [TalentAcquisitionReportsController::class, 'newHireTurnoverRateShow']);
            Route::post('download', [TalentAcquisitionReportsController::class, 'newHireTurnoverRateDownload'])->middleware('permission:can download new hire turnover rate report');
        });

        Route::group(['prefix' => 'time-to-hire', ['module:Time to Hire Report']], function () {
            Route::post('paginate', [TalentAcquisitionReportsController::class, 'timeToHireRatePaginate'])->middleware('permission:can paginate time to hire report');
            Route::post('show', [TalentAcquisitionReportsController::class, 'timeToHireRateShow']);
            Route::post('download', [TalentAcquisitionReportsController::class, 'timeToHireRateDownload'])->middleware('permission:can download time to hire report');
        });

    });

    Route::group(['prefix' => 'functions'], function () {


        Route::group(['prefix' => 'human_resource'], function () {
            // List of methods to get lists for filters
            Route::group(['prefix' => 'common', 'middleware' => []], function () {
                Route::get('employees', [CommonController::class, 'employees']);
                Route::get('branches', [CommonController::class, 'branches']);
                Route::get('corporations', [CommonController::class, 'corporations']);
                Route::get('divisions', [CommonController::class, 'divisions']);
                Route::get('departments', [CommonController::class, 'departments']);
                Route::get('sections', [CommonController::class, 'sections']);
                Route::get('units', [CommonController::class, 'units']);
                Route::get('supervisors', [CommonController::class, 'supervisors']);
                Route::get('positions', [CommonController::class, 'positions']);
                Route::get('employee-types', [CommonController::class, 'employeeTypes']);
            });

            // Settings control routes
            Route::group(['prefix' => 'settings', 'middleware' => ['role:Developer|Super Admin|Admin']], function () {
                Route::get('fetch', [SettingController::class, 'fetch']);
                Route::get('index', [SettingController::class, 'all']);

                Route::middleware('permission:can manage auto sync setup')->group(function () {
                    Route::get('fetch-by-module', [SettingController::class, 'fetchByModule']);
                    Route::post('set-multiple', [SettingController::class, 'setMultiple']);
                });

                Route::post('set', [SettingController::class, 'set']);

                Route::post('set-active-status', [SettingController::class, 'setActiveStatus']);
            });

            Route::group(['prefix' => 'sm', 'middleware' => []], function () {

                Route::prefix('branch')->group(function () {

                    Route::post('create',   [SM_B::class, 'create_branch'])->middleware('permission:can create branch');

                    Route::middleware('permission:can manage branch')->group(function () {
                        Route::post('list',     [SM_B::class, 'init_list_branch']);
                        Route::post('update',   [SM_B::class, 'edit_branch']);
                        Route::post('search',   [SM_B::class, 'search_branch_name']);
                        Route::post('delete',   [SM_B::class, 'delete_branch']);
                    });
                });

                Route::prefix('loan_type')->group(function () {

                    Route::post('create',   [LoanController::class, 'create_loan'])->middleware('permission:can create loan');

                    Route::middleware('module_or_permission:Reports|can manage loan')->group(function () {
                        Route::post('list',     [LoanController::class, 'init_list_loan']);
                        Route::post('update',   [LoanController::class, 'edit_loan']);
                        Route::post('search',   [LoanController::class, 'search_loan_name']);
                        Route::post('delete',   [LoanController::class, 'delete_loan']);
                    });

                    Route::post('list_all', [LoanController::class, 'init_list_all_loan']);
                });

                Route::prefix('corporation')->group(function () {

                    Route::post('create',   [SM_C::class, 'create_corporation'])->middleware('permission:can create corporation');

                    Route::middleware('permission:can manage corporation')->group(function () {
                        Route::post('list',     [SM_C::class, 'init_list_corporation']);
                        Route::post('update',   [SM_C::class, 'edit_corporation']);
                        Route::post('search',   [SM_C::class, 'search_corporation_name']);
                        Route::post('delete',   [SM_C::class, 'delete_corporation']);
                    });
                });

                Route::prefix('division')->group(function () {

                    Route::get('{division_id}/show-employees', [SM_D::class, 'show_employees']);
                    Route::get('{division_id}/show-sections', [SM_D::class, 'show_sections']);
                    Route::get('{division_id}/show-units', [SM_D::class, 'show_units']);

                    Route::post('create',   [SM_D::class, 'create_division'])->middleware('permission:can create division');

                    Route::middleware('permission:can manage division')->group(function () {
                        Route::post('list',     [SM_D::class, 'init_list_division']);
                        Route::post('update',   [SM_D::class, 'edit_division']);
                        Route::post('search',   [SM_D::class, 'search_division_name']);
                        Route::post('delete',   [SM_D::class, 'delete_division']);
                    });
                });

                Route::prefix('department')->group(function () {

                    Route::get('{department_id}/show-employees', [SM_DD::class, 'show_employees']);
                    Route::get('{department_id}/show-divisions', [SM_DD::class, 'show_divisions']);

                    Route::get('{department_id}/show-units', [SM_DD::class, 'show_units']);
                    Route::get('{department_id}/show-division-until-units', [SM_DD::class, 'show_division_section_and_unit']);

                    Route::post('create',   [SM_DD::class, 'create_department'])->middleware('permission:can create department');

                    Route::middleware('permission:can manage department')->group(function () {
                        Route::post('list',     [SM_DD::class, 'init_list_department']);
                        Route::post('update',   [SM_DD::class, 'edit_department']);
                        Route::post('search',   [SM_DD::class, 'search_department_name']);
                        Route::post('delete',   [SM_DD::class, 'delete_department']);
                    });
                });

                Route::prefix('section')->group(function () {

                    Route::get('{section_id}/show-employees', [SectionsController::class, 'show_employees']);
                    Route::get('{section_id}/show-units', [SectionsController::class, 'show_units']);

                    Route::post('create',   [SectionsController::class, 'create_section'])->middleware('permission:can create section');

                    Route::middleware('permission:can manage section')->group(function () {
                        Route::post('list',     [SectionsController::class, 'init_list_section']);
                        Route::put('update',    [SectionsController::class, 'edit_section']);
                        Route::post('search',   [SectionsController::class, 'search_section_name']);
                        Route::delete('delete',   [SectionsController::class, 'delete_section']);
                    });
                });

                Route::prefix('unit')->group(function () {
                    Route::post('create',   [UnitsController::class, 'create_unit'])->middleware('permission:can create unit');

                    Route::get('{unit_id}/show-employees', [UnitsController::class, 'show_employees']);

                    Route::middleware('permission:can manage unit')->group(function () {
                        Route::post('list',     [UnitsController::class, 'init_list_unit']);
                        Route::put('update',    [UnitsController::class, 'edit_unit']);
                        Route::post('search',   [UnitsController::class, 'search_unit_name']);
                        Route::delete('delete',   [UnitsController::class, 'delete_unit']);
                    });
                });

                Route::prefix('position')->group(function () {
                    Route::get('/', [SM_P::class, 'index']);

                    Route::post('create',   [SM_P::class, 'create_position'])->middleware('permission:can create position');

                    Route::middleware('permission:can manage position')->group(function () {
                        Route::post('update',   [SM_P::class, 'edit_position']);
                        Route::get('list',     [SM_P::class, 'init_list_position']);
                        Route::post('search',   [SM_P::class, 'search_position_name']);
                        Route::post('delete',   [SM_P::class, 'delete_position']);
                    });

                    Route::get('list_all', [SM_P::class, 'init_list_all_position']);

                    Route::get('list_all_soft_delete',     [SM_P::class, 'list_all_soft_deleted']);
                    Route::post('search_soft_delete',     [SM_P::class, 'search_soft_delete']);
                    Route::post('search_soft_keyword',     [SM_P::class, 'search_soft_keyword']);
                    Route::post('restore_soft_delete',      [SM_P::class, 'restore_soft_delete']);
                });

                Route::prefix('schedule_type')->group(function () {
                    Route::post('create', [ScheduleTypeController::class, 'create'])->middleware('permission:can create schedule type');

                    Route::middleware('permission:can manage schedule type')->group(function () {
                        Route::post('update', [ScheduleTypeController::class, 'edit']);
                        Route::post('delete', [ScheduleTypeController::class, 'delete']);
                        Route::post('search', [ScheduleTypeController::class, 'search']);
                        Route::get('list', [ScheduleTypeController::class, 'init_list']);
                    });

                    Route::get('fetch_all', [ScheduleTypeController::class, 'fetch_all']);
                });

                Route::prefix('schedule_title')->group(function () {
                    Route::post('create', [ScheduleTitleController::class, 'create'])->middleware('permission:can create schedule title');

                    Route::middleware('permission:can manage schedule title')->group(function () {
                        Route::post('update', [ScheduleTitleController::class, 'edit']);
                        Route::post('delete', [ScheduleTitleController::class, 'delete']);
                        Route::post('search', [ScheduleTitleController::class, 'search']);
                        Route::get('list', [ScheduleTitleController::class, 'init_list']);
                    });

                    Route::get('fetch', [ScheduleTitleController::class, 'fetch_schedule_titles']);
                });

                Route::middleware('permission:can manage schedule template')->prefix('schedule_template')->group(function () {
                    Route::post('create_full', [ScheduleTemplateController::class, 'create_full']);
                    Route::post('edit_full', [ScheduleTemplateController::class, 'edit_full']);
                    Route::post('create', [ScheduleTemplateController::class, 'create']);
                    Route::post('delete', [ScheduleTemplateController::class, 'delete']);
                    Route::post('fetch_all', [ScheduleTemplateController::class, 'fetch_schedule_template']);
                    Route::post('set_basis', [ScheduleTemplateController::class, 'set_basis']);
                });

                Route::prefix('timetables')->group(function () {

                    Route::post('create', [TimetableController::class, 'create'])->middleware('permission:can create timetable');

                    Route::middleware('permission:can manage timetable')->group(function () {
                        Route::post('update', [TimetableController::class, 'update']);
                        Route::post('delete', [TimetableController::class, 'delete']);
                        Route::get('list', [TimetableController::class, 'list']);
                    });

                    Route::get('fetch', [TimetableController::class, 'fetch']);
                    Route::get('fetch-all', [TimetableController::class, 'fetchAll']);
                });

                Route::prefix('default_schedule')->group(function () {

                    Route::middleware('permission:can manage default schedule')->group(function () {
                        Route::post('list', [DefaultScheduleController::class, 'init_list']);
                        Route::post('search', [DefaultScheduleController::class, 'search']);
                        Route::post('inactive-schedules', [DefaultScheduleController::class, 'fetch_inactive_schedules']);
                        Route::post('set-active', [DefaultScheduleController::class, 'set_active_schedule']);
                    });

                    Route::post('current-active', [DefaultScheduleController::class, 'fetch_current_active']);
                });

                Route::prefix('roster_legend')->group(function () {
                    Route::post('create', [RosterLegendController::class, 'create_legend'])->middleware('permission:can create roster legend');

                    Route::middleware('permission:can manage roster legend')->group(function () {
                        Route::post('list',   [RosterLegendController::class, 'init_list_legend']);
                        Route::post('update', [RosterLegendController::class, 'update_legend']);
                        Route::post('search', [RosterLegendController::class, 'search_legend_name']);
                        Route::post('delete', [RosterLegendController::class, 'delete_legend']);
                    });
                });

                Route::prefix('roster_group')->group(function () {
                    Route::post('create', [RosterGroupController::class, 'create_group'])->middleware('permission:can create roster group');

                    Route::middleware('permission:can manage roster group')->group(function () {
                        Route::post('list',   [RosterGroupController::class, 'init_list_group']);
                        Route::post('update', [RosterGroupController::class, 'update_group']);
                        Route::post('search', [RosterGroupController::class, 'search_group_name']);
                        Route::post('delete', [RosterGroupController::class, 'delete_group']);
                    });

                    Route::prefix('group_positions')->group(function () {
                        Route::middleware('permission:can create group position')->group(function () {
                            Route::post('assign', [RosterGroupController::class, 'assign_group']);
                            Route::post('fetch_groups', [RosterGroupController::class, 'roster_groups']);
                            Route::post('fetch_positions', [RosterGroupController::class, 'fetch_positions']);
                        });

                        Route::middleware('permission:can manage group position')->group(function () {
                            Route::post('grouped_positions', [RosterGroupController::class, 'fetch_group_positions']);
                            Route::post('update', [RosterGroupController::class, 'edit_grouped_position']);
                            Route::post('delete', [RosterGroupController::class, 'delete_grouped_position']);
                        });
                    });
                });

                Route::prefix('shift')->group(function () {
                    Route::post('create', [ShiftController::class, 'create_shift'])->middleware('permission:can create shift');

                    Route::middleware('permission:can manage shift')->group(function () {
                        Route::post('list',   [ShiftController::class, 'init_list_shift']);
                        Route::post('update', [ShiftController::class, 'update_shift']);
                        Route::post('search', [ShiftController::class, 'search_shift_name']);
                        Route::post('delete', [ShiftController::class, 'delete_shift']);
                    });

                    Route::post('fetch', [ShiftController::class, 'fetch_shifts']);
                });

                Route::prefix('training_type')->group(function () {
                    Route::post('create', [TrainingTypeController::class, 'create']);
                    Route::post('edit', [TrainingTypeController::class, 'edit']);
                    Route::post('delete', [TrainingTypeController::class, 'delete']);
                    Route::get('list_all', [TrainingTypeController::class, 'list_all']);
                    Route::post('init_list', [TrainingTypeController::class, 'init_list']);
                    Route::post('search', [TrainingTypeController::class, 'search']);
                });

                Route::prefix('salary')->group(function () {

                    Route::prefix('standardization')->group(function () {

                        Route::post('create', [SalaryStandardizationController::class, 'create'])->middleware('permission:can create new tranche');

                        Route::middleware('permission:can manage new tranche')->group(function () {
                            Route::post('update', [SalaryStandardizationController::class, 'edit']);
                            Route::post('delete', [SalaryStandardizationController::class, 'delete']);
                            Route::get('list', [SalaryStandardizationController::class, 'init_list']);
                            Route::post('search', [SalaryStandardizationController::class, 'search']);
                        });

                        Route::get('fetch', [SalaryStandardizationController::class, 'fetch']);


                        Route::middleware('module_or_permission:Designation and Salaries|Recruitment|can manage active tranche')->group(function () {
                            Route::post('inactive-tranches', [SalaryStandardizationController::class, 'fetch_inactive_tranches']);
                            Route::post('set-active', [SalaryStandardizationController::class, 'set_active_tranche']);
                            Route::post('current-active', [SalaryStandardizationController::class, 'fetch_current_active']);
                        });
                    });

                    Route::prefix('grade')->group(function () {
                        Route::post('create', [SalaryGradeController::class, 'create']);
                        Route::post('update', [SalaryGradeController::class, 'edit']);
                        Route::post('delete', [SalaryGradeController::class, 'delete']);
                        Route::post('create', [SalaryGradeController::class, 'create']);

                        Route::group(['middleware' => 'permission:can manage regular salary grade table'], function () {
                            Route::post('create/batch', [SalaryGradeController::class, 'batch_create']);
                            Route::post('update/batch', [SalaryGradeController::class, 'batch_update']);
                            Route::prefix('regular')->group(function () {
                                Route::post('list', [SalaryGradeController::class, 'init_list_regular']);
                                Route::post('search', [SalaryGradeController::class, 'search_regular']);
                            });
                        });

                        Route::post('salary_grades', [SalaryGradeController::class, 'fetch_by_standardization'])->middleware('module_or_permission:Designation and Salaries|Recruitment|can manage regular salary grade table|can manage contractual salary grade table');

                        Route::middleware('permission:can manage contractual salary grade table')->prefix('contractual')->group(function () {
                            Route::post('list', [SalaryGradeController::class, 'init_list_contractual']);
                            Route::post('search', [SalaryGradeController::class, 'search_contractual']);
                        });
                    });
                });

                Route::middleware('permission:can manage bulk profile')->prefix('bulk_profile_rules')->group(function () {

                    Route::post('update', [BulkProfileRulesController::class, 'update']);
                    Route::get('fetch', [BulkProfileRulesController::class, 'fetch']);
                });

                // Biometric Devices Setup
                Route::prefix('biometric-devices')->group(function () {
                    Route::post('create', [BiometricDeviceController::class, 'create'])->middleware('permission:can create biometric device setup');

                    Route::middleware('permission:can manage biometric device setup')->group(function () {
                        Route::get('list', [BiometricDeviceController::class, 'list']);
                        Route::post('update', [BiometricDeviceController::class, 'update']);
                        Route::post('delete', [BiometricDeviceController::class, 'delete']);
                    });

                    Route::get('all', [BiometricDeviceController::class, 'index']);
                    Route::get('fetch', [BiometricDeviceController::class, 'fetch']);
                });

                Route::prefix('service_record')->group(function () {
                    Route::prefix('remark')->group(function () {
                        Route::get('/', [RemarkController::class, 'index']);
                        Route::post('create', [RemarkController::class, 'create_remark']);
                        Route::post('list', [RemarkController::class, 'init_list_remark']);
                        Route::post('search', [RemarkController::class, 'search_remark']);
                        Route::post('update', [RemarkController::class, 'edit_remark']);
                        Route::post('delete', [RemarkController::class, 'delete_remark']);
                    });
                });

                // Special Pays and Allowances for Payroll
                Route::prefix('allowances')->group(function () {

                    Route::get('all', [AllowanceController::class, 'all']);
                    Route::get('fetch', [AllowanceController::class, 'show']);

                    Route::post('create', [AllowanceController::class, 'create'])->middleware('permission:can create allowance');

                    Route::middleware('permission:can manage allowance')->group(function () {
                        Route::get('list', [AllowanceController::class, 'index']);
                        Route::post('update', [AllowanceController::class, 'update']);
                        Route::post('delete', [AllowanceController::class, 'delete']);
                    });
                });

                Route::prefix('special-pays')->group(function () {

                    Route::get('all', [SpecialPayController::class, 'all']);
                    Route::get('fetch', [SpecialPayController::class, 'show']);

                    Route::post('create', [SpecialPayController::class, 'create'])->middleware('permission:can create special pay');

                    Route::middleware('permission:can manage special pay')->group(function () {
                        Route::get('list', [SpecialPayController::class, 'index']);
                        Route::post('update', [SpecialPayController::class, 'update']);
                        Route::post('delete', [SpecialPayController::class, 'delete']);
                        Route::post('download', [SpecialPayController::class, 'download_template']);
                        Route::post('upload', [SpecialPayController::class, 'upload_template']);

                        Route::prefix('employee')->group(function (){
                            Route::put('update', [SpecialPayController::class, 'update_employee_special_pay']);
                        });

                        Route::prefix('frequency')->group(function (){
                            Route::get('/', [SpecialPayFrequencyController::class, 'index']);
                        });
                    });
                });

                Route::prefix('holiday')->group(function () {
                    Route::prefix('type')->group(function () {
                        Route::post('create', [HolidayTypeController::class, 'create'])->middleware('permission:can create holiday type');

                        Route::middleware('permission:can manage holiday type')->group(function () {
                            Route::post('list', [HolidayTypeController::class, 'init_list']);
                            Route::post('search', [HolidayTypeController::class, 'search_type']);
                            Route::post('edit', [HolidayTypeController::class, 'edit']);
                            Route::post('delete', [HolidayTypeController::class, 'delete']);
                        });
                    });

                    Route::post('create', [HolidayController::class, 'create'])->middleware('permission:can create holiday');

                    Route::middleware('permission:can manage holiday')->group(function () {
                        Route::post('list', [HolidayController::class, 'init_list']);
                        Route::post('search', [HolidayController::class, 'search']);
                        Route::post('edit', [HolidayController::class, 'edit']);
                        Route::post('delete', [HolidayController::class, 'delete']);
                    });

                    Route::post('fetch_type', [HolidayController::class, 'fetch_type']);
                    Route::get('fetch_holidays', [HolidayController::class, 'fetch_holidays']);
                });

                Route::prefix('suspension')->group(function () {
                    Route::post('create', [SuspensionController::class, 'create'])->middleware('permission:can create suspension');

                    Route::middleware('permission:can manage suspension')->group(function () {
                        Route::post('list', [SuspensionController::class, 'init_list']);
                        Route::post('search', [SuspensionController::class, 'search']);
                        Route::post('edit', [SuspensionController::class, 'edit']);
                        Route::post('delete', [SuspensionController::class, 'delete']);
                    });
                });

                Route::prefix('item_codes')->group(function () {

                    Route::post('create', [ItemCodeController::class, 'create'])->middleware('permission:can create item code');

                    Route::middleware('permission:can manage item code')->group(function () {
                        Route::post('update', [ItemCodeController::class, 'update']);
                        Route::post('delete', [ItemCodeController::class, 'destroy']);
                    });

                    Route::post('list', [ItemCodeController::class, 'index'])->middleware('module_or_permission:Dashboard|can manage item code');

                    Route::get('get-by-position', [ItemCodeController::class, 'getByPosition']);
                });

                Route::prefix('contributions/types')->group(function () {
                    Route::post('/', [ContributionController::class, 'store'])->middleware('permission:can create contribution');

                    Route::middleware('permission:can manage contribution')->group(function () {
                        Route::get('/', [ContributionController::class, 'index']);
                        Route::get('/{type}', [ContributionController::class, 'show']);
                        Route::put('/{type}', [ContributionController::class, 'update']);
                        Route::delete('/{type}', [ContributionController::class, 'destroy']);
                    });
                });

                Route::prefix('longevity-pay')->group(function () {
                    Route::post('setup/', [LongevityController::class, 'store'])->middleware('permission:can create longevity pay');

                    Route::middleware('permission:can manage longevity pay')->group(function () {
                        Route::get('setup/', [LongevityController::class, 'index']);
                        Route::put('setup/{setup}', [LongevityController::class, 'update']);

                        Route::post('current', [LongevityController::class, 'get_active']);
                        Route::post('set-active', [LongevityController::class, 'set_as_active']);
                    });
                });

                Route::prefix('night-differential-pay')->group(function () {
                    Route::post('setup/', [NightDifferentialPayController::class, 'store'])->middleware('permission:can create night differential pay');

                    Route::middleware('permission:can manage night differential pay')->group(function () {
                        Route::get('setup/', [NightDifferentialPayController::class, 'index']);
                        Route::put('setup/{setup}', [NightDifferentialPayController::class, 'update']);

                        Route::post('current', [NightDifferentialPayController::class, 'get_active']);
                        Route::post('set-active', [NightDifferentialPayController::class, 'set_as_active']);
                    });
                });
            });

            Route::group(['prefix' => 'leave-type'], function () {

                Route::get('eligibility', [LeaveEligibleController::class, 'showEligibleLeaveType']);

                Route::middleware('permission:can manage leave type')->group(function () {
                    Route::put('/{id}', [LeaveTypeController::class, 'update']);
                    Route::get('paginate', [LeaveTypeController::class, 'paginate']);
                });

                Route::post('/', [LeaveTypeController::class, 'store'])->middleware('permission:can create leave type');
                Route::get('/', [LeaveTypeController::class, 'index']);
                Route::get('/{id}', [LeaveTypeController::class, 'show']);

            });

            Route::group(['prefix' => 'leave-balance-history'], function () {
                Route::get('paginate', [LeaveCreditController::class, 'paginateByUserLeaveId'])->middleware('module_or_permission:Leave - Employee|can paginate and view employee leave records');
            });

            Route::group(['prefix' => 'office'], function () {

                Route::get('/', [OfficesController::class, 'index']);

                Route::middleware('permission:can manage office')->group(function () {

                    Route::get('paginate', [OfficesController::class, 'paginate']);
                    Route::delete('delete', [OfficesController::class, 'delete']);
                    Route::post('search', [OfficesController::class, 'search']);
                    Route::put('/{office_id}', [OfficesController::class, 'update']);
                });

                Route::post('/', [OfficesController::class, 'store'])->middleware('permission:can create office');

                Route::get('/{office_id}/show-departments', [OfficesController::class, 'showDepartments']);
                Route::get('/{office_id}/show-units', [OfficesController::class, 'showUnits']);
                Route::get('/{office_id}/show-divisions-and-units', [OfficesController::class, 'showDivisionsAndUnits']);
                Route::get('/{office_id}/show-divisions', [OfficesController::class, 'showDivisions']);
                Route::get('/{office_id}/show-employees', [OfficesController::class, 'showEmployees']);
                Route::get('/{office_id}', [OfficesController::class, 'show']);
            });

            Route::put('leave-balance/{user_id}', [LeaveBalanceController::class, 'update'])->middleware('permission:can update leave balance');
            Route::apiResource('leave-balance', LeaveBalanceController::class)->except(['update']);


            Route::group(['prefix' => 'reports'], function () {
                Route::prefix('cost-per-hire')->group(function () {
                    Route::post('create-report', [TalentAcquisitionReportsController::class, 'createCostPerHireReport'])->middleware('permission:can create cost per hire report');
                    Route::post('fetch-table', [TalentAcquisitionReportsController::class, 'fetchCostPerHireReport'])->middleware('permission:can paginate cost per hire report');
                    Route::post('export-report', [TalentAcquisitionReportsController::class, 'exportCostPerHireReport'])->middleware('permission:can download cost per hire report');
                });

                Route::prefix('time-since-last-promotion')->group(function () {
                    Route::post('create-report', [TalentAcquisitionReportsController::class, 'createTimeSinceLastPromotionReport'])->middleware('permission:can create time since last promotion report');
                    Route::post('fetch-table', [TalentAcquisitionReportsController::class, 'fetchTimeSinceLastPromotionReport'])->middleware('permission:can paginate time since last promotion report');
                    Route::post('view-data', [TalentAcquisitionReportsController::class, 'viewTimeSinceLastPromotionData'])->middleware('permission:can paginate time since last promotion report');
                    Route::post('export', [TalentAcquisitionReportsController::class, 'exportTimeSinceLastPromtionReport'])->middleware('permission:can download time since last promotion report');
                });

                Route::post('/', [ReportsController::class, 'store'])->middleware('permission:can create reports');
                Route::get('/{reports}', [ReportsController::class, 'show'])->middleware('permission:can paginate reports');

                Route::group(['prefix' => 'absence'], function () {
                    Route::post('index', [AbsenceRerportController::class, 'index'])->middleware('permission:can paginate absenteeism report');
                    Route::post('fetch-card', [AbsenceRerportController::class, 'fetchCardDetails']);
                    Route::post('create-report', [AbsenceRerportController::class, 'createAbsenceReport'])->middleware('permission:can create absenteeism report');
                    Route::post('export', [AbsenceRerportController::class, 'export'])->middleware('permission:can download absenteeism report');
                });
            });

            Route::get('reports-download', [ReportsController::class, 'download'])->middleware('permission:can download reports');

            Route::group(['prefix' => 'roster_schedule'], function () {
                Route::group(['prefix' => 'roster'], function () {
                    Route::post('create', [RosterController::class, 'create_roster'])->middleware(['permission:can create roster']);
                    Route::post('set_details', [RosterController::class, 'set_details'])->middleware(['permission:can set roster details']);
                    Route::post('search', [RosterController::class, 'search_roster'])->middleware(['permission:can view roster schedule']);
                    Route::post('table', [RosterController::class, 'fetch_roster_schedule'])->middleware(['permission:can view roster table']);
                    Route::post('set_emp_required_hours', [RosterController::class, 'set_employee_required_hours'])->middleware(['permission:can set roster details']);
                    Route::post('set_head_required_hours', [RosterController::class, 'set_head_required_hours'])->middleware(['permission:can set roster details']);
                    Route::post('update', [RosterController::class, 'update_roster_schedule'])->middleware(['permission:can update roster']);
                });

                Route::group(['prefix' => 'listing'], function () {
                    Route::post('roster-group-per-day', [RosterController::class, 'fetch_roster_day_per_group']);
                    Route::post('employees', [RosterController::class, 'fetch_employees']);
                    Route::post('head_employee', [RosterController::class, 'fetch_head_employee']);
                    Route::post('employee_group', [RosterController::class, 'fetch_group_employees']);
                    Route::post('roster_legend', [RosterController::class, 'fetch_roster_legend']);
                    Route::post('fetch_partition', [RosterController::class, 'fetch_partition']);
                });
                Route::group(['prefix' => 'assign'], function () {
                    Route::post('number_of_staff_per_day', [RosterController::class, 'assign_number_of_staff_per_day'])->middleware(['permission:can set roster details']);
                    Route::post('employee_per_day', [RosterController::class, 'assign_employee_shifts'])->middleware('permission:can assign roster schedule shift');
                    Route::post('head_employee_shift', [RosterController::class, 'assign_head_employee_shift'])->middleware('permission:can assign roster schedule shift');
                    Route::post('roster_status', [RosterController::class, 'set_roster_status'])->middleware(['permission:can set roster status']);
                    Route::post('bulk_employee_shift', [RosterController::class, 'assign_bulk_employee_shift'])->middleware('permission:can assign roster schedule shift');
                });
                Route::group(['prefix' => 'remove'], function () {
                    //Please update middleware of this API upon creating permission for this API
                    Route::post('employee', [RosterController::class, 'remove_employees'])->middleware('permission:can assign roster schedule shift');
                    Route::post('employee_shift', [RosterController::class, 'remove_employee_shifts'])->middleware('permission:can assign roster schedule shift');
                    Route::post('head_employee_shift', [RosterController::class, 'remove_head_employee_shifts'])->middleware('permission:can assign roster schedule shift');
                    Route::post('group', [RosterController::class, 'remove_group'])->middleware('permission:can assign roster schedule shift');
                });

                Route::group(['prefix' => 'update'], function () {
                    Route::put('employee_shift', [RosterController::class, 'update_employee_shift'])->middleware(['permission:can update roster']);
                    Route::put('head_employee_shift', [RosterController::class, 'update_head_employee_shift'])->middleware(['permission:can update roster']);
                    Route::put('head_employee_roster_legend', [RosterController::class, 'update_head_employee_roster_legend'])->middleware(['permission:can update roster']);
                    Route::put('employee_roster_legend', [RosterController::class, 'update_employee_roster_legend'])->middleware(['permission:can update roster']);
                });
            });
            // Biometrics Device Connection Functions
            Route::group(['prefix' => 'biometric-device'], function () {
                Route::middleware('module_or_permission:can manage biometric device setup|RFID|Biometrics|')->group(function () {
                    Route::get('test-connection', [DeviceConnectionController::class, 'testConnection']);
                    Route::get('test-voice', [DeviceConnectionController::class, 'testVoice']);
                    Route::get('restart', [DeviceConnectionController::class, 'restart']);
                    Route::get('sleep', [DeviceConnectionController::class, 'sleep']);
                    Route::get('shutdown', [DeviceConnectionController::class, 'shutdown']);
                });

                Route::get('disconnect', [DeviceConnectionController::class, 'disconnect']);

                // Sync
                Route::prefix('sync')->group(function () {
                    Route::post('users', [SyncController::class, 'syncUsersByDevice']);
                    Route::post('users-multiple', [SyncController::class, 'syncUsersMultipleDevices']);
                    Route::post('system-sync-multiple', [SyncController::class, 'syncMultipleUserId']);
                });
            });

            Route::group(['prefix' => 'export'], function () {
                Route::middleware('module:Active Employees')->group(function () {
                    Route::get("employee", [CSVController::class, 'export_employee']);
                    Route::get("validate_export", [CSVController::class, 'validate_export']);
                    Route::post("employee_failure", [CSVController::class, 'export_employee_failure']);
                });

                Route::group(['prefix' => 'attendance'], function () {
                    Route::get("export", [CSVController::class, 'export_attendance'])->middleware(['permission:can download employee attendance template']);
                    Route::post("failure", [CSVController::class, 'export_attendance_failure']);
                });
            });

            Route::group(['prefix' => 'leave-refund'], function () {
                Route::post("search", [LeaveRefundController::class, 'index'])->middleware('permission:can manage leave refund');
                Route::post("fetch", [LeaveRefundController::class, 'fetchLeaveRefund']);
            });

            Route::group(['prefix' => 'pds', 'middleware' => ['module:Active Employees']], function () {
                Route::group(['prefix' => 'employee', 'middleware' => []], function () {
                    Route::post("create", [PersonalDataSheetController::class, 'create'])->middleware(['permission:can create personal data sheet']);
                    Route::post("create_files", [PersonalDataSheetController::class, 'createFiles']);
                    Route::post("roll_back_user", [PersonalDataSheetController::class, 'rollBackUser']);
                    Route::get("validate", [PersonalDataSheetController::class, 'validation']);
                });
                Route::post('file_attachment_download', [EmployeeController::class, 'file_attachment_download']);

                Route::post('fetch_filter_update', [PDSController::class, 'fetch_filter_update'])->middleware(['permission:can paginate view update approve decline onhold request personal data sheet']);
                Route::post('fetch_update_request', [PDSController::class, 'fetch_update_request']);
                Route::post('download', [PDSController::class, 'download_proof']);
            });

            Route::group(['prefix' => 'import'], function () {
                Route::post("employee", [CSVController::class, 'import_employee'])->middleware(['module_or_permission:Active Employees|can create personal data sheet']);
                Route::post("attendance", [CSVController::class, 'import_attendance'])->middleware(['module_or_permission:Attendance|can create employee attendance']);
            });

            Route::group(['prefix' => 'employee'], function () {

                Route::get('show-actual-designation', [EmployeeController::class, 'showEmployeeActualDesignation']);
                Route::put('update-actual-designation', [EmployeeController::class, 'updateEmployeeActualDesignation']);

                Route::middleware('module:Active Employees|Recruitment')->group(function () {
                    Route::group(['prefix' => 'type'], function () {
                        Route::post('create', [EmployeeTypeController::class, 'create'])->middleware('permission:can create employee type');

                        Route::middleware('permission:can manage employee type')->group(function () {
                            Route::post('edit', [EmployeeTypeController::class, 'edit']);

                            Route::post('search', [EmployeeTypeController::class, 'search']);
                            Route::post('delete', [EmployeeTypeController::class, 'delete']);
                        });
                        Route::get('init_list', [EmployeeTypeController::class, 'init_list'])->middleware('module_or_permission:Recruitment|can manage employee type');
                    });

                    Route::post('fetch_employee_paginate', [EmployeeController::class, 'fetch_employee_paginate'])->middleware('permission:can fetch employee paginate');
                });

                Route::group(['prefix' => 'schedule'], function () {

                    Route::get('corp_branch', [EmployeeScheduleController::class, 'fetch_branch_corps']);
                    Route::post('filter', [EmployeeScheduleController::class, 'filter_employees_main'])->middleware('permission:can paginate and view employee schedule');

                    Route::group(['prefix' => 'individual'], function () {
                        Route::post('create', [EmployeeScheduleController::class, 'assign_individual_schedule'])->middleware('permission:can assign employee schedule');
                        Route::post('edit', [EmployeeScheduleController::class, 'edit'])->middleware('permission:can update employee schedule');
                        Route::post('list', [EmployeeScheduleController::class, 'init_list_employees'])->middleware('permission:can paginate and view employee schedule');
                        Route::post('fetch_schedule_templates', [EmployeeScheduleController::class, 'fetch_schedule_templates']);
                        Route::get('employees', [EmployeeScheduleController::class, 'fetch_employees_without_schedule']);
                        Route::get('employees-without-schedule', [EmployeeScheduleController::class, 'paginate_employees_without_schedule']);
                    });

                    Route::group(['prefix' => 'bulk'], function () {
                        Route::post('filter', [EmployeeScheduleController::class, 'filter_employees_bulk']);
                        Route::post('assign', [EmployeeScheduleController::class, 'assign_bulk_schedules'])->middleware('permission:can assign employee schedule');
                        Route::post('employees-with-schedule', [EmployeeScheduleController::class, 'fetch_employees_schedule']);
                        Route::post('delete', [EmployeeScheduleController::class, 'delete'])->middleware('permission:can delete employee schedule');
                    });
                });

                Route::middleware('permission:can manage rfid')->prefix('rfid')->group(function () {
                    Route::post('create', [RFIDController::class, 'create_rfid']);
                    Route::post('update', [RFIDController::class, 'update_rfid']);
                    Route::post('fetch', [RFIDController::class, 'fetch_all_rfid']);
                    Route::post('search', [RFIDController::class, 'search_employee']);
                    Route::delete('delete', [RFIDController::class, 'delete_rfid']);
                    Route::post('restore', [RFIDController::class, 'restore_deleted_rfid']);
                    Route::post('init_list', [RFIDController::class, 'init_list_deleted_rfid']);
                    Route::post('filter', [RFIDController::class, 'filter_rfid']);
                    Route::post('approve', [RFIDController::class, 'approve']);
                    Route::post('decline', [RFIDController::class, 'decline']);
                    Route::get('employees', [RFIDController::class, 'employees']);
                    Route::post('sync-card', [RFIDController::class, 'syncCard']);
                    Route::post('sync-all-card', [RFIDController::class, 'syncAllCard']);
                });

                Route::middleware('module_or_permission:Biometrics|can manage biometrics setup')->prefix('biometrics')->group(function () {
                    Route::post('create_bio', [BiometricsController::class, 'create_biometrics']);
                    Route::get('fetch_bio', [BiometricsController::class, 'fetch_all_biometrics']);
                    Route::post('fetch_single_bio', [BiometricsController::class, 'fetch_single_biometrics']);
                    Route::post('update_bio', [BiometricsController::class, 'update_biometrics']);
                    Route::post('delete_bio', [BiometricsController::class, 'delete_biometrics']);
                    Route::post('filter_bio', [BiometricsController::class, 'filter_biometrics']);
                    Route::post('approve_bio', [BiometricsController::class, 'approve']);
                    Route::post('decline_bio', [BiometricsController::class, 'decline']);
                    Route::get('list', [BiometricsController::class, 'index']);
                    Route::post('create-device-user', [BiometricsController::class, 'createDeviceUser']);
                    Route::post('sync-fingerprints', [BiometricsController::class, 'syncFingerprints']);
                    Route::post('sync-all-fingerpints', [BiometricsController::class, 'syncAllFingerprints']);
                    Route::get('employees', [BiometricsController::class, 'employees']);

                    Route::post('edit-device-user', [BiometricSyncController::class, 'editDeviceUser']);
                });

                Route::prefix('attendance')->group(function () {
                    Route::post('create', [AttendanceController::class, 'create'])->middleware('permission:can create employee attendance');
                    Route::get('fetch_name', [AttendanceController::class, 'fetch_name']);
                    Route::post('edit', [AttendanceController::class, 'edit'])->middleware('permission:can update employee attendance');
                    Route::post('delete', [AttendanceController::class, 'delete'])->middleware('permission:can delete employee attendance');
                    Route::post('search', [AttendanceController::class, 'filter_attendance'])->middleware('permission:can paginate and view employee attendance');

                    Route::get('sync-device-attendance', [AttendanceController::class, 'syncBiometricsAttendance']);
                });

                Route::prefix('time-record')->group(function () {
                    Route::prefix('list')->group(function () {
                        Route::post('attendance-dates', [DTRController::class, 'search_attendance_date'])->middleware('permission:can view employee daily time record');
                        Route::post('employees', [DTRController::class, 'fetch_employees'])->middleware('permission:can view employee daily time record');
                    });
                });

                Route::get('sync-from-device', [SyncController::class, 'syncUserId']);
                Route::get('check-device-connection', [BiometricsController::class, 'checkConnection']);

                Route::post('fetch_employee_service_record', [EmployeeController::class, 'fetchEmployeeServiceRecord'])->middleware('permission:can paginate employee service record');
                Route::get('fetch-inactive-employee', [EmployeeController::class, 'fetch_inactive_employee']);
                Route::get('fetch_employees', [EmployeeController::class, 'fetch_employees']);
            });

            Route::group(['prefix' => 'loan', 'middleware' => ['module:Loans']], function () {
                Route::post('create_user_loan', [UserLoanController::class, 'create_user_loan'])->middleware('permission:can create and update employee loan');
                Route::post('update_user_loan', [UserLoanController::class, 'update_user_loan']);
                Route::get('init_list_user_loan', [UserLoanController::class, 'init_list_user_loan']);
                Route::post('search_user_loan', [UserLoanController::class, 'search_user_loan'])->middleware('permission:can paginate and view employee loans');
                Route::post('approved_loans_list', [UserLoanController::class, 'approved_loans_list']);
                Route::get('paginate-loan-transaction-history', [UserLoanController::class, 'paginate_loan_transaction_history']);
                Route::get('loan-summary', [UserLoanController::class, 'loan_summary']);
                Route::get('get-loan-transaction-history', [UserLoanController::class, 'get_loan_transaction_history']);
            });

            Route::group(['prefix' => 'training', 'middleware' => ['role:Developer|Super Admin|Admin']], function () {
                Route::get('generate_training_id', [TrainingController::class, 'generate_training_id']);
                Route::post('create', [TrainingController::class, 'create']);
                Route::get('paginate_training', [TrainingController::class, 'paginate_training']);
                Route::put('update', [TrainingController::class, 'update_training']);
                Route::delete('delete', [TrainingController::class, 'delete']);
                Route::get('list_trainings', [TrainingController::class, 'list_trainings']);
                Route::get('init_list_employee', [TrainingController::class, 'init_list_employee']);

                Route::group(['prefix' => 'employee'], function () {
                    Route::post('', [UserTrainingController::class, 'index']);
                    Route::post('training_history', [UserTrainingController::class, 'training_history']);
                    Route::put('update', [UserTrainingController::class, 'update']);
                    Route::post('fetch_edit_training', [UserTrainingController::class, 'fetch_edit_training']);
                    Route::post('destroy', [UserTrainingController::class, 'destroy']);
                    Route::get('show', [UserTrainingController::class, 'show']);
                    Route::post('store', [UserTrainingController::class, 'store']);
                });
                // Route::post('create_multiple', [TrainingController::class, 'create_multiple']);
                // Route::post('list_trainings_latest', [TrainingController::class, 'list_trainings_latest']);
                // Route::post('list_trainings_filter', [TrainingController::class, 'list_trainings_filter']);
                // Route::post('list_trainings', [TrainingController::class, 'list_trainings']);
            });

            Route::group(['prefix' => 'UserSupervisors', 'middleware' => ['module:Employee Profile']], function () {

                Route::middleware('permission:can create supervisor')->group(function () {
                    Route::post('create', [SC::class, 'create_supervisor']);
                    Route::get('list_candidate_supervisor', [SC::class, 'list_candidate_supervisor']);
                });

                Route::middleware('permission:can manage supervisor')->group(function () {
                    Route::get('init_list_supervisors', [SC::class, 'init_list_supervisors']);
                    Route::post('delete', [SC::class, 'delete_supervisor']);
                });

                Route::get('init_list_all_supervisors', [SC::class, 'init_list_all_supervisors'])->middleware('permission:can manage supervisor|can manage supervisee');

                Route::post('search', [SC::class, 'search']);

                Route::get('list_deleted', [SC::class, 'list_all_deleted']);
                Route::post('restore', [SC::class, 'restore_soft_delete']);
                Route::post('edit', [SC::class, 'edit_supervisor']);
            });

            Route::group(['prefix' => 'UserSupervisors', 'middleware' => ['module:Employee Profile']], function () {

                Route::middleware('permission:can create supervisee')->group(function () {
                    Route::post('create_usc', [USC::class, 'create_multiple']);
                    Route::post('fetch_supervisee', [USC::class, 'fetch_supervisee']);
                    Route::get('fetch_supervisee_pagination', [USC::class, 'fetch_supervisee_pagination']);
                });

                Route::middleware('permission:can manage supervisee')->group(function () {
                    Route::get('init_list_all_usc', [USC::class, 'init_list_all_usc']);
                    Route::post('search_usc', [USC::class, 'search_usc']);
                    Route::post('edit_usc', [USC::class, 'edit_usc']);
                    Route::post('delete_usc', [USC::class, 'delete_usc']);
                });

                Route::post('init_list_usc', [USC::class, 'init_list_usc']);

                Route::post('search_deleted_usc', [USC::class, 'search_deleted_usc']);
                Route::get('list_deleted_usc', [USC::class, 'list_deleted_usc']);
                Route::post('restore_deleted_usc', [USC::class, 'restore_deleted_usc']);
            });


            Route::group(['prefix' => 'employee_cases'], function () {

                Route::group(['prefix' => 'EmployeeCases'], function () {
                    Route::post('create', [EmployeeCaseController::class, 'create'])->middleware('permission:can create employee case');
                    Route::post('init_list', [EmployeeCaseController::class, 'init_list'])->middleware('permission:can paginate employee case');
                    Route::post('edit', [EmployeeCaseController::class, 'edit'])->middleware('permission:can edit employee case');
                    Route::post('filter', [EmployeeCaseController::class, 'filter'])->middleware('permission:can paginate employee case');
                    Route::get('fetch_users_without_record', [EmployeeCaseController::class, 'fetch_users_without_record']);
                    Route::get('fetch_users_with_record', [EmployeeCaseController::class, 'fetch_users_with_record']);
                });
            });

            Route::group(['prefix' => 'learning_development', 'middleware' => ['role:Developer|Super Admin|Admin']], function () {

                Route::group(['prefix' => 'merit'], function () {
                    Route::post('delete', [MeritController::class, 'delete']);
                    Route::post('create', [MeritController::class, 'create']);
                    Route::post('edit', [MeritController::class, 'edit']);
                    Route::post('init_list_merit', [MeritController::class, 'init_list']);
                    Route::post('filter', [MeritController::class, 'filter']);
                    Route::post('approve', [MeritController::class, 'approve']);
                    Route::post('decline', [MeritController::class, 'decline']);
                });

                Route::group(['prefix' => 'demerit'], function () {
                    Route::post('delete', [DemeritController::class, 'delete']);
                    Route::post('create', [DemeritController::class, 'create']);
                    Route::post('edit', [DemeritController::class, 'edit']);
                    Route::post('init_list_demerit', [DemeritController::class, 'init_list']);
                    Route::post('filter', [DemeritController::class, 'filter']);
                    Route::post('approve', [DemeritController::class, 'approve']);
                    Route::post('decline', [DemeritController::class, 'decline']);
                });

                Route::group(['prefix' => 'training_bond'], function () {
                    Route::post('create', [TrainingBondController::class, 'create_trainingbond']);
                    Route::post('update', [TrainingBondController::class, 'update_trainingbond']);
                    Route::post('delete', [TrainingBondController::class, 'delete_trainingbond']);
                    Route::post('init_training_bond', [TrainingBondController::class, 'init_training_bond']);
                    Route::post('filter', [TrainingBondController::class, 'filter']);
                });
            });

            Route::group(['prefix' => 'salary', 'middleware' => ['module:Designation and Salaries']], function () {
                Route::post('create_user_salary', [UserSalaryController::class, 'create_user_salary'])->middleware('permission:can assign employee salary and allowances');
                Route::post('batch_create_user_salary', [UserSalaryController::class, 'batch_create_user_salary'])->middleware('permission:can assign employee salary and allowances');
                Route::get('fetch_employee_without_salary', [UserSalaryController::class, 'fetch_employee_without_salary']);
                Route::get('fetch_employee_with_salary', [UserSalaryController::class, 'fetch_employee_with_salary']);
                Route::post('search_employee_with_salary', [UserSalaryController::class, 'search_employee_with_salary'])->middleware('permission:can paginate employee with salary');
                Route::post('update_user_salary', [UserSalaryController::class, 'update_user_salary'])->middleware('permission:can update employee salary and designation');
                Route::post('update_request_user_salary', [UserSalaryController::class, 'update_request_user_salary'])->middleware('permission:can update employee salary and designation');
                Route::post('fetch_salary_step', [UserSalaryController::class, 'fetch_salary_step']);
                Route::post('fetch_salary_value', [UserSalaryController::class, 'fetch_salary_value']);
                Route::post('fetch_private_salary', [UserSalaryController::class, 'fetch_private_salary']);
                Route::post('fetch_positions', [UserSalaryController::class, 'fetch_positions']);
                Route::post('salary_for_reemployment', [UserSalaryController::class, 'salary_for_reemployment'])->middleware('permission:can assign employee salary and allowances');
                Route::post('fetch_employee_for_reemployment', [UserSalaryController::class, 'fetch_employee_for_reemployment']);
                Route::post('fetch-employee-allowance-and-special', [UserSalaryController::class, 'fetch_employee_allowances_special_pays'])->middleware('permission:can view employee salary and designation history');

                // Allowances and Special pays
                Route::prefix('allowances')->group(function () {
                    Route::get('list', [EmployeeAllowanceController::class, 'index']);
                    Route::post('assign', [EmployeeAllowanceController::class, 'assign']);
                    Route::post('employee', [EmployeeAllowanceController::class, 'getEmployeeAllowances'])->middleware('permission:can view employee salary and designation history');
                });

                Route::prefix('special-pays')->group(function () {
                    Route::get('list', [EmployeeSpecialPayController::class, 'index']);
                    Route::post('assign', [EmployeeSpecialPayController::class, 'assign']);
                });
            });

            Route::group(['prefix' => 'payroll', 'middleware' => ['module:Payroll']], function () {
                Route::post('generate', [PayrollController::class, 'generate_payroll'])->middleware('permission:can generate payroll');

                Route::middleware('permission:can paginate and view payroll')->group(function () {
                    Route::get('get-payroll', [PayrollController::class, 'get_payroll']);
                    Route::post('list', [PayrollController::class, 'list_payrolls']);
                    Route::post('details', [PayrollController::class, 'fetch_payroll_details']);
                    Route::get('download-journal', [PayrollController::class, 'generate_journal']);
                    Route::get('fetch-employee-record', [PayrollController::class, 'fetch_employee_with_record']);
                });

                Route::middleware('permission:can approve and void payroll')->group(function () {
                    Route::post('approve', [PayrollController::class, 'approve_payroll']);
                    Route::post('void', [PayrollController::class, 'void_payroll']);
                });

                Route::post('download', [PayrollController::class, 'download_file'])->middleware('permission:can download payroll file');

                Route::post('update', [PayrollController::class, 'update_payroll']);
                Route::post('entities', [PayrollController::class, 'fetch_entities']);

                Route::prefix('employee')->group(function () {
                    Route::middleware('permission:can paginate and view payroll')->group(function () {
                        Route::post('lwop', [PayrollController::class, 'fetch_timekeeping_deductions']);
                        Route::post('breakdown', [PayrollController::class, 'fetch_employee_payroll_breakdown']);
                    });
                    Route::post('void', [PayrollController::class, 'void_employee_payroll'])->middleware('permission:can void payroll');
                });

                Route::prefix('bank-setup')->group(function () {
                    Route::get('fetch', [PayrollController::class, 'fetch_setup']);
                    Route::post('create', [PayrollController::class, 'create_setup']);
                    Route::post('update', [PayrollController::class, 'update_setup']);
                });
            });

            Route::group(['prefix' => 'approval', 'middleware' => ['module:Approvals|Dashboard']], function () {

                Route::prefix('overtime')->group(function () {
                    Route::prefix('application')->group(function () {
                        Route::get('init_list', [OvertimeController::class, 'init_list'])->middleware('permission:can paginate and view overtime application');
                        Route::post('fetch_user_overtime', [OvertimeController::class, 'fetch_user_overtime'])->middleware('permission:can paginate and view overtime application');
                        Route::post('filter_request', [OvertimeController::class, 'filter_request'])->middleware('permission:can paginate and view overtime application');
                        Route::post('approve', [OvertimeController::class, 'approve'])->middleware('permission:can approve and decline overtime application');
                        Route::post('approve_all', [OvertimeController::class, 'approve_all'])->middleware('permission:can approve and decline overtime application');
                        Route::post('decline', [OvertimeController::class, 'decline'])->middleware('permission:can approve and decline overtime application');
                        Route::post('delete', [OvertimeController::class, 'delete'])->middleware('permission:can delete overtime application');
                        Route::get('fetch-all-data', [OvertimeController::class, 'init_list_no_paginate']);
                    });

                    Route::prefix('accomplishment-report')->group(function () {
                        Route::get('list', [OvertimeReportController::class, 'init_list'])->middleware('permission:can paginate and view overtime accomplishment report');
                        Route::post('fetch', [OvertimeReportController::class, 'fetch_report'])->middleware('permission:can paginate and view overtime accomplishment report');
                        Route::post('filter', [OvertimeReportController::class, 'filter_request'])->middleware('permission:can paginate and view overtime accomplishment report');
                        Route::post('approve', [OvertimeReportController::class, 'approve'])->middleware('permission:can approve and decline overtime accomplishment report');
                        Route::post('disapprove', [OvertimeReportController::class, 'disapprove'])->middleware('permission:can approve and decline overtime accomplishment report');
                        Route::post('file-download', [OvertimeReportController::class, 'file_download'])->middleware('permission:can paginate and view overtime accomplishment report');
                    });
                });

                Route::prefix('cto')->group(function () {
                    Route::prefix('applications')->group(function () {
                        Route::post('init_list', [CTOController::class, 'fetch_cto_applications'])->middleware('permission:can paginate and view cto applications');
                        Route::post('fetch_cto', [CTOController::class, 'fetch_application'])->middleware('permission:can paginate and view cto applications');
                        Route::post('approve', [CTOController::class, 'approve'])->middleware('permission:can approve and decline cto applications');
                        Route::post('disapprove', [CTOController::class, 'disapprove'])->middleware('permission:can approve and decline cto applications');
                    });

                    Route::prefix('points')->group(function () {
                        Route::post('list/employee', [COCPointsController::class, 'fetch_cto_users'])->middleware('permission:can paginate and view cto records');
                        Route::post('list/points', [COCPointsController::class, 'fetch_points'])->middleware('permission:can paginate and view cto records');
                        Route::post('points', [COCPointsController::class, 'fetch_remaining_points'])->middleware('permission:can paginate and view cto records');
                    });
                });

                Route::prefix('undertime')->group(function () {
                    Route::get('init_list', [UndertimeController::class, 'init_list'])->middleware('permission:can paginate and view undertime application');
                    Route::post('fetch_user_undertime', [UndertimeController::class, 'fetch_user_undertime'])->middleware('permission:can paginate and view undertime application');
                    Route::post('filter_request', [UndertimeController::class, 'filter_request'])->middleware('permission:can paginate and view undertime application');
                    Route::post('approve', [UndertimeController::class, 'approve'])->middleware('permission:can approve and decline undertime application');
                    Route::post('approve_all', [UndertimeController::class, 'approve_all'])->middleware('permission:can approve and decline undertime application');
                    Route::post('decline', [UndertimeController::class, 'decline'])->middleware('permission:can approve and decline undertime application');
                    Route::post('delete', [UndertimeController::class, 'delete'])->middleware('permission:can delete undertime application');
                    Route::get('fetch-all-data', [UndertimeController::class, 'init_list_no_paginate']);
                });

                Route::middleware('role:Developer|Super Admin|Admin')->prefix('training')->group(function () {
                    Route::get('init_list', [TrainingApprovalController::class, 'init_list']);
                    Route::post('filter_request', [TrainingApprovalController::class, 'filter_request']);
                    Route::post('filter_employee', [TrainingApprovalController::class, 'filter_employee']);
                    Route::post('approve', [TrainingApprovalController::class, 'approve']);
                    Route::post('approve_all', [TrainingApprovalController::class, 'approve_all']);
                    Route::post('decline', [TrainingApprovalController::class, 'decline']);
                    Route::post('delete', [TrainingApprovalController::class, 'delete']);
                });
            });

            Route::group(['prefix' => 'exit', 'middleware' => ['module:Resigned Employees']], function () {
                Route::middleware('permission:can manage resigned employee')->group(function () {
                    Route::post('user', [ExitController::class, 'fetch_name']);
                    Route::post('filter', [ExitController::class, 'filter_employees_resigned']);
                    Route::post('re-employment', [ExitController::class, 'reemploy']);
                    Route::get('get_approved', [ExitController::class, 'fetch_users_clearance_approved']);
                });
            });

            Route::group(['prefix' => 'clearance', 'middleware' => ['module:Clearance']], function () {


                Route::middleware('permission:can manage clearance')->group(function () {
                    Route::post('create_clearance', [ClearanceController::class, 'create_clearance']);
                    Route::post('update_clearance', [ClearanceController::class, 'update_clearance']);
                    Route::post('list', [ClearanceController::class, 'list_clearances']);
                    Route::post('fetch', [ClearanceController::class, 'fetch_clearance']);
                    Route::post('approve', [ClearanceController::class, 'approve']);
                    Route::post('approve-all', [ClearanceController::class, 'batch_approve']);
                    Route::post('decline', [ClearanceController::class, 'decline']);
                    Route::post('file_attachment_download', [ClearanceController::class, 'file_attachment_download']);
                });

                Route::post('send', [ClearanceController::class, 'send']);
                Route::post('compliances', [ClearanceController::class, 'create_compliances']);

                Route::get('CCS', [ClearanceController::class, 'CCS_list']);
            });

            Route::group(['prefix' => 'exit-interview', 'middleware' => ['module:Exit Interview']], function () {

                Route::middleware('permission:can manage exit interview')->group(function () {
                    Route::post('create_exit_interview', [EI::class, 'create_exit_interview']);
                    Route::post('file_attachment_download', [EI::class, 'file_attachment_download']);
                    Route::post('update_interview', [EI::class, 'update_interviews']);
                    Route::post('fetch_all_interview', [EI::class, 'fetch_all_interviews']);
                    Route::post('done', [EI::class, 'set_as_done']);
                    Route::post('fetch_single_interview', [EI::class, 'fetch_single_interviews']);
                });

                Route::get('users', [EI::class, 'fetch_users_with_clearance']);

                Route::post('delete_interview', [EI::class, 'delete_interviews']);
                Route::get('get_done', [EI::class, 'fetch_users_interview_done']);
            });


            Route::group(['prefix' => 'leave-management', 'middleware' => ['module:Leave Records|Dashboard']], function () {

                Route::prefix('application')->group(function () {
                    Route::post('fetch_all', [LeaveApplicationController::class, 'fetch_records'])->middleware('module_or_permission:Dashboard|can paginate and view employee leave application');
                    Route::post('approve', [LeaveApplicationController::class, 'approve'])->middleware('permission:can approve and decline employee leave application');
                    Route::post('decline', [LeaveApplicationController::class, 'decline'])->middleware('permission:can approve and decline employee leave application');
                    Route::post('cancel', [LeaveApplicationController::class, 'cancel']);
                    Route::post('approve-all', [LeaveApplicationController::class, 'batch_approve']);
                    Route::post('fetch-leave', [LeaveApplicationController::class, 'fetch_leave']);
                });

                Route::prefix('credits')->group(function () {
                    Route::post('list', [LeaveCreditController::class, 'fetch_credits']);
                    Route::post('employee/balances', [LeaveCreditController::class, 'fetch_balances'])->middleware('permission:can paginate and view employee leave records');
                    Route::post('employee/fetch-balance-by-leave-type', [LeaveCreditController::class, 'fetch_balance_by_leave_type']);
                    Route::put('update', [LeaveCreditController::class, 'update']);
                });

                Route::post('list/employees', [LeaveCreditController::class, 'fetch_leave_users'])->middleware('permission:can paginate and view employee leave records');
                Route::get('types', [EmployeeLeaveController::class, 'fetch_types']);
                Route::get('details', [EmployeeLeaveController::class, 'fetch_details']);
            });

            Route::group(['prefix' => 'designation', 'middleware' => ['module:Designation and Salaries|Dashboard']], function () {
                Route::post('update_company_details', [DesignationHistoryController::class, 'update_company_details'])->middleware('permission:can manage transfers');
                Route::post('fetch_designation_history', [DesignationHistoryController::class, 'fetch_designation_history'])->middleware('permission:can view employee salary and designation history');
                Route::get('fetch_employees', [DesignationHistoryController::class, 'fetch_employees']);
            });


            Route::group(['prefix' => 'pds', 'middleware' => ['role:Developer|Super Admin|Admin']], function () {
                Route::post('approve', [PDSController::class, 'approve']);
                Route::post('approve_all', [PDSController::class, 'approve_all']);
                Route::post('decline', [PDSController::class, 'decline']);
                Route::post('decline_all', [PDSController::class, 'decline_all']);
                Route::post('on-hold', [PDSController::class, 'on_hold']);
                Route::post('fetch_pds_position', [PDSPerPositionController::class, 'fetch_pds_position']);
            });

            Route::group(['prefix' => 'PDSprint', 'middleware' => ['role:Developer|Super Admin|Admin']], function () {
                Route::post('viewPDF', [PDSPerPositionController::class, 'view_pds']);
                Route::post('printPDF', [PDSPrintPerPositionController::class, 'print_pds_admin']);
            });

            Route::group(['prefix' => 'emp-type-history', 'middleware' => ['module:Active Employees']], function () {
                Route::post('create', [EmployeeTypeHistoryController::class, 'create_records'])->middleware(['permission:can create employee type history']);
                Route::post('fetch', [EmployeeTypeHistoryController::class, 'fetch_emp_type']);
                Route::put('update', [EmployeeTypeHistoryController::class, 'updateEmpTypeHistory']);
                Route::post('generate', [EmployeeTypeHistoryController::class, 'generateAppointmentForm']);
            });

            Route::group(['prefix' => 'appointment-form', 'middleware' => ['role:Developer|Super Admin|Admin|Employee']], function () {
                Route::post('upload-form', [DownloadUploadAppointmentForm::class, 'uploadAppointmentForm']);
                Route::post('download-form', [DownloadUploadAppointmentForm::class, 'downloadAppointmentForm']);
                Route::get('fetch', [DownloadUploadAppointmentForm::class, 'fetchEmployeeAppointmentForm']);
                Route::get('history', [DownloadUploadAppointmentForm::class, 'appointmentFormHistory']);
            });

            Route::group(['prefix' => 'saln_reports', 'middleware' => ['module:SALN Report']], function () {
                Route::post('download-saln-report', [EmployeeSalnReportsController::class, 'download'])->middleware('permission:can paginate and view employee saln report');
                Route::group(['prefix' => 'saln-reports'], function () {
                    Route::post('/', [EmployeeSalnReportsController::class, 'store'])->middleware('permission:can approve and decline employee saln report');
                    Route::get('/{id}', [EmployeeSalnReportsController::class, 'show'])->middleware('permission:can paginate and view employee saln report');
                });
            });

            Route::group(['prefix' => 'promotion', 'middleware' => ['module:Promotion']], function () {
                Route::post('create-requirements', [SupplementalController::class, 'create_request']);
                Route::post('fetch-applications', [PromotionController::class, 'fetch_applications']);
                Route::post('download-requirements', [PromotionController::class, 'download_file_attachment']);
                Route::post('process-requirements', [PromotionController::class, 'approve_disapprove_requirement']);
                Route::post('process-promotion', [PromotionController::class, 'process_application']);
                Route::post('process-reschedule', [PromotionController::class, 'process_reschedule']);
                Route::post('generate-form', [PromotionController::class, 'generate_application_form']);
                Route::post('upload-form', [PromotionController::class, 'upload_application_form']);
                Route::post('download-form', [PromotionController::class, 'download_application_form']);
                Route::post('promote-employee', [PromotionController::class, 'promote_employee']);
                Route::post('list-application-status', [PromotionController::class, 'list_applications']);
            });
        });

        Route::group(['prefix' => 'roster_reschedule'], function () {
            Route::post('list_reschedule', [RosterRescheduleController::class, 'list_request_schedule'])->middleware(['permission:can view roster reschedule request']);
            Route::post('change_status', [RosterRescheduleController::class, 'approve_request'])->middleware(['permission:can review reschedule request']);
        });

        Route::group(['prefix' => 'employee'], function () {

            Route::group(['prefix' => 'promotion', 'middleware' => ['module:Promotion - Employee']], function () {
                Route::post('fetch-jobs', [PCE::class, 'fetch_jobs']);
                Route::post('fetch-applications', [PCE::class, 'fetch_applications']);
                Route::post('create-application', [PCE::class, 'create']);
                Route::post('upload-requirements', [PCE::class, 'upload_file_attachment']);
                Route::post('download-requirements', [PromotionController::class, 'download_file_attachment']);
                Route::post('process-promotion', [PromotionController::class, 'process_application']);
                Route::post('request-reschedule', [PCE::class, 'request_reschedule']);
                Route::post('download-form', [PromotionController::class, 'download_application_form']);
            });

            Route::group(['prefix' => 'roster', 'middleware' => ['module:Dashboard - Employee|Schedule|Roster']], function () {
                Route::post('current_schedule', [RosterEmployeeController::class, 'fetch_available_dates']);
                Route::post('create_reschedule', [RosterEmployeeController::class, 'create_reschedule_request']);
                Route::get('fetch_reschedule', [RosterEmployeeController::class, 'fetch_reschedule_request']);
                Route::post('update_reschedule', [RosterEmployeeController::class, 'update_reschedule_request']);
                Route::post('fetch_schedule', [RosterEmployeeController::class, 'fetch_current_schedule']);
                Route::post('fetch_holiday', [RosterEmployeeController::class, 'fetchHolidayByMonthAndYear']);
                Route::post('fetch_leave', [RosterEmployeeController::class, 'fetchLeaveByMonthAndYear']);
                Route::post('fetch_cto', [RosterEmployeeController::class, 'fetchCTOByMonthAndYear']);
                Route::post('fetch_table', [RosterEmployeeController::class, 'fetch_roster_schedule']);
                Route::post('search', [RosterEmployeeController::class, 'search_roster']);
                Route::get('fetch_roster_table', [RosterEmployeeController::class, 'fetch_roster_table']);
                Route::get('list_reschedule_request', [RosterRescheduleController::class, 'fetch_requestor_request']);
                Route::post('change_status', [RosterRescheduleController::class, 'requestee_approve_request']);
            });

            Route::group(['prefix' => 'attendance'], function () {
                //    Route::get('fetch-attendance/{id}', [ EmployeeAttendanceController::class, 'fetch_employee_attendance']);
                Route::post('search_date', [EmployeeAttendanceController::class, 'search_attendance_date']);
                Route::post('filter_attendance', [EmployeeAttendanceController::class, 'filter_employee_attendance']);
                Route::post('filter/date_type', [EmployeeAttendanceController::class, 'filter_by_date_type']);
                Route::post('time_in', [EmployeeAttendanceController::class, 'create_check_in']);
                Route::post('time_out', [EmployeeAttendanceController::class, 'update_check_out']);
                Route::get('status', [EmployeeAttendanceController::class, 'fetch_status']);
            });
            Route::group(['prefix' => 'payslip', 'middleware' => ['module:Payslip - Employee']], function () {
                Route::post('paginate_payslip', [PayslipController::class, 'paginate_payslip']);
                Route::post('get_pdf', [PayslipController::class, 'get_pdf']);
                Route::get('fetch_filter_period', [PayslipController::class, 'fetch_filter_period']);
            });


            Route::get('fetch_employee_info', [EmployeeController::class, 'fetchEmployeeInfo']);
            Route::get('fetch_employee_pds', [EmployeeController::class, 'fetchEmployeePDS']);

            Route::group(['prefix' => 'loans', 'middleware' => ['module:Loan - Employee']], function () {
                Route::post('list_all', [LoanController::class, 'init_list_all_loan']);
                Route::post('search_user_loan', [UserLoanController::class, 'search_user_loan'])->middleware('permission:can paginate and view employee loans');
                Route::post('create_user_loan', [UserLoanController::class, 'create_user_loan'])->middleware('permission:can create and update employee loan');
                Route::post('update_user_loan', [UserLoanController::class, 'update_user_loan']);
                Route::post('fetch_loan', [LoanEmployeeController::class, 'fetch_employee_loans']);
                Route::post('approved_loan', [LoanEmployeeController::class, 'fetch_approved_loans']);
            });

            Route::group(['prefix' => 'reports', 'middleware' => ['module:Reports - Employee']], function () {
                Route::apiResource('saln-reports', EmployeeSalnReportsController::class);
                Route::get('generate-saln-form', [EmployeeSalnReportsController::class, 'generate']);
                Route::post('download-saln-report', [EmployeeSalnReportsController::class, 'download']);
            });

            //* SPMS
            Route::group(['prefix' => 'spms', 'middleware' => ['module:SPMS - Employee']], function () {

                Route::get('show-pcr', [EmployeeController::class, 'showEmployeePcr']);

                Route::group(['prefix' => 'evaluation'], function () {
                    Route::post('create', [EmployeeEvaluationController::class, 'store']);
                    Route::put('update-status/{evaluation_id}', [EmployeeEvaluationController::class, 'updateEvaluationStatus']);
                    Route::get('fetch-supervisor', [EmployeeEvaluationController::class, 'fetchSupervisor']);
                    Route::post('list-evaluation-forms', [EmployeeEvaluationController::class, 'list_evaluation_form']);
                    Route::post('list-other-evaluations', [EmployeeEvaluationController::class, 'list_other_evaluation']);
                    Route::post('view-evaluation-form', [EmployeeEvaluationController::class, 'view_evaluation_form']);
                    Route::post('submit', [EmployeeEvaluationController::class, 'submit_evaluation']);
                    Route::put('stamp', [EmployeeEvaluationController::class, 'stamp']);
                });

                Route::group(['prefix' => 'mfo'], function () {
                    Route::post('create-mfo-entry', [MetricEvaluationController::class, 'create_mfo_entry']);
                    Route::put('update-mfo-entry/{metric_evaluation_id}', [MetricEvaluationController::class, 'update_mfo_entry']);
                    Route::put('update-mfo-status/{metric_evaluation_id}', [MetricEvaluationController::class, 'update_mfo_status']);
                    Route::get('count-status', [MetricEvaluationController::class, 'count_by_mfo_status']);
                    Route::delete('delete-mfo-entry/{metric_evaluation_id}', [MetricEvaluationController::class, 'delete_mfo_entry']);
                    Route::get('fetch-mfo-entries', [MetricEvaluationController::class, 'fetch_mfo_entries']);
                    Route::post('submit-mfo', [MetricEvaluationController::class, 'submit_mfo_for_status']);
                    Route::get('fetch_evaluation_classification', [MetricEvaluationController::class, 'fetch_evaluation_classification']);

                    Route::get('{metric_evaluation_id}/history', [MetricEvaluationHistoryController::class, 'showMetricHistory']);

                    Route::group(['prefix' => 'score-card'], function () {
                        Route::post('/', [BalanceScoreCardController::class, 'store']);
                        Route::get('/get-by-mfo', [BalanceScoreCardController::class, 'getByMfo']);
                        Route::put('/{score_card_id}', [BalanceScoreCardController::class, 'update']);
                    });
                });
            });
            // Leaves
            Route::group(['prefix' => 'leave', 'middleware' => ['module:Leave - Employee']], function () {
                Route::post('create', [EmployeeLeaveController::class, 'create_request']);
                Route::post('fetch_all', [EmployeeLeaveController::class, 'fetch_all_request']);
                Route::post('delete', [EmployeeLeaveController::class, 'delete_request']);
                Route::post('update', [EmployeeLeaveController::class, 'update_request']);
                Route::post('cancel', [EmployeeLeaveController::class, 'cancel_request']);
                Route::get('balances', [LeaveCreditController::class, 'fetch_balances']);

                Route::post('check-saved', [EmployeeLeaveController::class, 'fetch_saved_leave']);
                Route::post('fetch-leave', [EmployeeLeaveController::class, 'fetch_viewed_leave']);

                Route::get('types', [EmployeeLeaveController::class, 'fetch_types']);
                Route::get('details', [EmployeeLeaveController::class, 'fetch_details']);
                Route::get('supervisors', [EmployeeLeaveController::class, 'supervisor_list']);
                Route::post('filter', [EmployeeLeaveController::class, 'filter_request']);

                Route::get('view-request', [LeaveApproverController::class, 'paginate']);
                Route::put('update', [LeaveApproverController::class, 'update']);

                Route::prefix('credits')->group(function () {
                    Route::post('list', [EmployeeLeaveController::class, 'fetch_credits']);
                });
            });

            Route::group(['prefix' => 'exit', 'middleware' => ['module:Exit - Employee']], function () {
                Route::post('file_attachment_download', [ClearanceFormController::class, 'file_attachment_download']);
                Route::get('clearance', [ClearanceFormController::class, 'fetchActiveClearance']);
                Route::post('update', [ClearanceFormController::class, 'update_clearance']);
            });

            Route::group(['prefix' => 'pds'], function () {
                Route::post('fetch_new_update', [PDSEmployeeController::class, 'fetch_new_update']);
                Route::post('fetch_result', [PDSEmployeeController::class, 'fetch_result']);
                Route::post('create', [PDSEmployeeController::class, 'create']);
                Route::post('update_file', [PDSEmployeeController::class, 'update_file']);
                Route::post('set_as_acknowledged', [PDSEmployeeController::class, 'set_as_acknowledged']);
                Route::get('expiration_date_checker', [PDSEmployeeController::class, 'expiration_date_checker']);
                Route::post('upload', [PDSEmployeeController::class, 'upload_proof']);
                Route::post('download', [PDSEmployeeController::class, 'download_proof']);
            });

            Route::group(['prefix' => 'PDSPrintEmployee', 'middleware' => []], function () {

                Route::post('exportPDF', [PDSPrintController::class, 'export_employee_pdf']);
            });
        });

        Route::group(['prefix' => 'employee', 'middleware' => ['module:Dashboard - Employee|Daily Time Record']], function () {
            Route::group(['prefix' => 'attendance'], function () {
                Route::get('fetch-attendance/{id}', [EmployeeAttendanceController::class, 'fetch_employee_attendance']);
            });
        });


        Route::group(['prefix' => 'user_overtime' , 'middleware' => ['module:Overtime - Employee']], function () {
            Route::post('create', [UOC::class, 'create_user_overtime']);
            Route::post('fetch_user_overtime', [UOC::class, 'fetch_user_overtime']);

            Route::group(['prefix' => 'accomplishment-report'], function () {
                Route::post('create', [UOC::class, 'create_report']);
                Route::post('fetch', [UOC::class, 'fetch_report']);
                Route::post('file-download', [UOC::class, 'file_download']);
            });

            Route::group(['prefix' => 'statement-overtime'], function () {
                Route::post('fetch', [UOC::class, 'fetch_statement']);
            });
        });

        Route::group(['prefix'  =>  'cto', 'middleware' => ['module:Overtime - Employee']], function () {
            Route::post('create', [CTOApplicationController::class, 'create_cto_application']);
            Route::put('{cto_application_id}/cancel', [CTOApplicationController::class, 'cancel_cto_application']);
            Route::post('fetch_all', [CTOApplicationController::class, 'fetch_applications']);
            Route::post('fetch_points', [CTOApplicationController::class, 'fetch_points']);
        });

        Route::group(['prefix' => 'user_undertime', 'middleware' => ['module:Undertime - Employee']], function () {
            Route::post('create', [UUC::class, 'create_user_undertime']);
            Route::post('fetch_user_undertime', [UUC::class, 'fetch_user_undertime']);

            Route::post('fetch_schedule', [UUC::class, 'fetch_schedule']);
        });

        Route::get('fetch-permissions', [PermissionController::class, 'fetch_permissions']);
        //Access Management
        Route::group(['prefix' => 'access-management', 'middleware' => ['module:Role Management']], function () {
            Route::group(['prefix' => 'group-management'], function () {
                Route::group(['prefix' => 'role-has-system'], function () {
                    Route::post('create', [RoleHasSystemController::class, 'create']);
                    Route::get('fetch-by-system', [RoleHasSystemController::class, 'fetchBySystem']);
                    Route::get('paginate', [RoleHasSystemController::class, 'paginate']);
                    Route::post('update', [RoleHasSystemController::class, 'update']);
                });
                Route::group(['prefix' => 'role'], function () {
                    Route::post('create', [RoleController::class, 'create']);
                    Route::post('update', [RoleController::class, 'update']);
                    Route::post('delete', [RoleController::class, 'delete']);
                    Route::get('fetch', [RoleController::class, 'fetch']);
                    Route::get('paginate', [RoleController::class, 'paginate']);
                });

                Route::group(['prefix' => 'role-leader'], function () {
                    Route::post('create', [RoleLeaderController::class, 'create']);
                    Route::post('update', [RoleLeaderController::class, 'update']);
                });

                Route::group(['prefix' => 'system'], function () {
                    Route::post('create', [SystemController::class, 'create']);
                    Route::post('update', [SystemController::class, 'update']);
                    Route::post('delete', [SystemController::class, 'delete']);
                    Route::get('paginate', [SystemController::class, 'paginate']);
                    Route::get('fetch', [SystemController::class, 'fetch']);
                });

                Route::group(['prefix' => 'system-module'], function () {
                    Route::post('create', [SystemModuleController::class, 'create']);
                    Route::post('update', [SystemModuleController::class, 'update']);
                    Route::post('delete', [SystemModuleController::class, 'delete']);
                    Route::get('fetch', [SystemModuleController::class, 'fetch']);
                    Route::get('paginate', [SystemModuleController::class, 'paginate']);
                });

                Route::group(['prefix' => 'role-system-module'], function () {
                    Route::post('create', [RoleSystemModuleController::class, 'create']);
                    Route::post('delete', [RoleSystemModuleController::class, 'delete']);
                    Route::get('fetch-by-role-id', [RoleSystemModuleController::class, 'fetchByRoleID']);
                });

                Route::group(['prefix' => 'user-type'], function () {
                    Route::get('list-user-type', [UserTypeController::class, 'list_user_types']);
                    Route::post('fetch-user-type', [UserTypeController::class, 'fetch_user_type_by_id']);
                    Route::post('search-user-type', [UserTypeController::class, 'search_user_type']);
                    Route::post('edit-user-type', [UserTypeController::class, 'edit_user_type_permissions']);
                });

                Route::group(['prefix' => 'model-has-role'], function () {
                    Route::post('create', [ModelHasRoleController::class, 'create']);
                    Route::post('delete', [ModelHasRoleController::class, 'delete']);
                    Route::get('fetch-role-member', [UserController::class, 'fetchRoleMember']);
                    Route::get('fetch-by-role-id', [ModelHasRoleController::class, 'fetchByRoleID']);
                });

                Route::group(['prefix' => 'user'], function () {
                    Route::get('fetch', [UserController::class, 'fetch']);
                    Route::get('fetch-candidate-leader', [UserController::class, 'fetchCandidateLeader']);
                });

                Route::group(['prefix' => 'subrole'], function () {
                    Route::post('create', [SubRoleController::class, 'create']);
                    Route::post('delete', [SubRoleController::class, 'delete']);
                    Route::get('fetch', [SubRoleController::class, 'fetch']);
                    Route::get('fetch-module', [SubRoleModuleController::class, 'fetchModule']);
                    Route::get('is-root', [SubRoleController::class, 'isRoot']);
                });
            });
        });
    });
});
