<?php

namespace Suiterus\Adg\Requests\SPMS\MetricEvaluation;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;

class UpdateRequest extends FormRequest {

    public function authorize(): bool {
        $employeeEvaluation = EmployeeEvaluation::where('id', $this->employee_evaluation_id)
        ->where(function ($query) {
            $query->where('employee_id', Auth::id())
                ->orWhere('evaluator', Auth::id());
        })->first();

        return $employeeEvaluation ? true : false;
    }

    public function rules(): array {
        return [
            'metric_evaluation_id' => 'required|exists:' . env('ADG_DB_CONNECTION') . '.metric_evaluation,id',
            'evaluation_classification_id' => 'required|exists:' . env('ADG_DB_CONNECTION') . '.evaluation_classifications,id',
            'employee_evaluation_id' => 'required|exists:' . env('ADG_DB_CONNECTION') . '.employee_evaluation,id',
        ];
    }

}