<?php

namespace Suiterus\Adg\Requests\SPMS\MetricEvaluation;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Suiterus\Adg\Models\SPMS\MetricEvaluation;

class DeleteRequest extends FormRequest {

    public function authorize(): bool {
        $metricEvaluation = MetricEvaluation::whereHas('performanceEvaluation.employeeEvaluation', function ($query){
            $query->where('employee_id', Auth::id());
        })->where('id', $this->route('metric_evaluation_id'))->first();

        return $metricEvaluation ? true : false;
    }

    public function rules(): array {
        return [
            'metric_evaluation_id' => 'required|exists:' . env('ADG_DB_CONNECTION') . '.metric_evaluation,id',
        ];
    }

    public function prepareForValidation() {
        $this->merge([
            'metric_evaluation_id' => $this->route('metric_evaluation_id')
        ]);
    } 

}