<?php

namespace Suiterus\Adg\Requests\Mentorship;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            "program_title" => 'required|string',
            "program_type" => 'required|integer',
        ];
    }

    public function messages()
    {
        return [
            'program_title.required' => 'Program Title is required',
            'program_type.required' => 'Program type is required',
        ];
    }

    public function prepareForValidation()
    {
        $this->merge([
            'created_by' => Auth::id()
        ]);
    }
}
