<?php

namespace Suiterus\Adg\Requests\Mentorship\Session;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Adg\Models\Mentorship\MentorshipMentor;

class UpdateDateRequest extends FormRequest
{
    public function authorize(): bool
    {
        $mentorshipMentor = MentorshipMentor::where('mentor_id', Auth::id())->first();

        $hasValidRole = Auth::user()->hasRole(['Super Admin', 'Admin', 'Developer']);

        return $hasValidRole || $mentorshipMentor;
    }

    public function rules(): array
    {
        return [
            'session_id' => 'required|exists:' . env('ADG_DB_CONNECTION') . '.mentorship_sessions,id',
            "start_date" => 'required|date',
            "end_date" => 'required|date',
            "start_time" => 'required',
            "end_time" => 'required',
        ];
    }
}
