<?php

namespace Suiterus\Adg\Requests\Mentorship\Report;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Adg\Models\Mentorship\MentorshipMentor;

class UpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        $mentorshipMentor = MentorshipMentor::where('mentor_id', Auth::id())->first();

        $hasValidRole = Auth::user()->hasRole(['Super Admin', 'Admin', 'Developer']);

        return $hasValidRole || $mentorshipMentor;
    }

    public function rules(): array
    {
        return [
            "id" => 'required|exists:'.env('ADG_DB_CONNECTION').'.'. env('ADG_DB_DATABASE').'.mentorship_reports,id',
        ];
    }
}
