<?php

namespace Suiterus\Adg\Requests\Mentorship\Report;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            "mentorship_id" => 'required|exists:'.env('ADG_DB_CONNECTION').'.'. env('ADG_DB_DATABASE').'.mentorships,id'
        ];
    }

    public function prepareForValidation()
    {
        $this->merge([
            'created_by' => Auth::id()
        ]);
    }
}
