<?php

namespace Suiterus\Adg\Requests\Mentorship\Invite;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Adg\Models\Mentorship\MentorshipInvite;

class UpdateRequest extends FormRequest
{
    public function authorize(): bool
    {

        $mentorshipInvite = MentorshipInvite::where([
            ['id', $this->route('mentorship_invite')],
            ['mentee_id', Auth::id()]
        ])->first();

        $hasValidRole = Auth::user()->hasRole(['Super Admin', 'Admin', 'Developer']);

        return $hasValidRole || $mentorshipInvite;
    }

    public function rules(): array
    {
        return [
            'status' => 'required|integer|between:2,3'
        ];
    }
}
