<?php

namespace Suiterus\Adg\Requests\Mentorship\Invite;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;

class PaginateRequest extends FormRequest
{
    public function authorize(): bool
    {

        $hasValidRole = Auth::user()->hasRole(['Super Admin', 'Admin', 'Developer']);

        return $hasValidRole || (Auth::id() == $this->user_id);
    }

    public function rules(): array
    {
        return [];
    }
}
