<?php

namespace Suiterus\Adg\Requests\Mentorship\Attachment;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Adg\Models\Mentorship\MentorshipAttachment;

class DownloadRequest extends FormRequest
{
    public function authorize(): bool
    {
        $attachment = MentorshipAttachment::where('id', $this->id)->where(function($query) {
            $query->whereHas('session.invites', function($query){
                $query->where('mentee_id', Auth::id());
            })->orWhereHas('session.mentors', function($query) {
                $query->where('mentor_id', Auth::id());
            })->orWhereHas('session', function($query) {
                $query->where('created_by', Auth::id());
            });
        })->first();

        $hasValidRoles = Auth::user()->hasRole(['Super Admin', 'Admin', 'Developer']);

        return $hasValidRoles || $attachment;
    }

    public function rules(): array
    {
        return [
            "id" => 'required|exists:'.env('ADG_DB_CONNECTION').'.'. env('ADG_DB_DATABASE').'.mentorship_attachments,id'
        ];
    }

}
