<?php

namespace Suiterus\Adg\Requests\LeaveBalance;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'credits' => 'required|numeric',
            'is_negative' => 'required',
            'leave_type_id' => 'required|numeric',
            'new_balance' => 'required|numeric|min:0',
            'user_id' => 'required|exists:' . env('DB_CONNECTION') . '.users,id',
            'remarks' => 'required|string|max:50'
        ];
    }
}
