<?php

namespace Suiterus\Adg\Requests\LeaveApprover;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Adg\Models\LeaveManagement\LeaveApprover;

class LeaveApproverRequest extends FormRequest
{
    public function authorize(): bool
    {

        $leaveApprover = LeaveApprover::where([
            ['id', $this->id],
            ['approver_id', Auth::id()]
        ])->first();

        return Auth::check() && $leaveApprover && Auth::user()->is_supervisor;
    }

    public function rules(): array
    {
        return [];
    }
}
