<?php

namespace Suiterus\Adg\Requests\Leave;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\LeaveManagement\LeaveApprover;
use Suiterus\Adg\Models\LeaveManagement\Requests\Leave;

class DownloadLeaveFormRequest extends FormRequest
{
    public function authorize(): bool
    {

        $leaveApprover = LeaveApprover::where([
            ['approver_id', Auth::id()],
            ['leave_id', $this->leave_id]
        ])->first();

        $leave = Leave::where([
            ['id', $this->leave_id],
            ['user_id', Auth::id()]
        ])->first();

        if ($leaveApprover || $leave || Auth::user()->hasRole(['Super Admin', 'Admin' , 'Developer'])) {
            return true;
        }

        return false;
    }

    public function rules(): array
    {
        return [];
    }
}
