<?php

namespace Suiterus\Adg\Reports;

use Illuminate\Support\Carbon;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;

use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;


class TimeSinceLastPromotionExcelReport implements FromArray, WithHeadings, WithStyles, WithMapping, ShouldAutoSize, WithEvents
{
    private $data;
    public function __construct($data)
    {
        $this->data = $data;
    }

    public function array(): array
    {
        return $this->data;
    }


    public function headings(): array
    {
        return [
            'Employee ID',
            'Employee Name',
            'Date Hired',
            'Date Of Promotion',
            'Time Since Last Promotion'
        ];
    }

    public function map($query): array
    {
        return [
            $query['employee_id'],
            $query['employee_name'],
            $query['date_hired'],
            $query['date_of_promotion'],
            $query['time_since_last_promotion'],
        ];

    }

    public function styles(Worksheet $sheet)
    {
        $styleArray = array(
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_LEFT,
                'wrapText' => true
            ],
        );

        $headerStyle = [
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'wrapText' => true
            ],
            'font' => [
                'bold' => true,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ],
            ],
        ];

        $contentStyle = array(
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_RIGHT,
                'wrapText' => true
            ],
        );

        //headers
        $sheet->getStyle([1, 1, 5, 1])->applyFromArray($headerStyle);
        $sheet->getStyle('A')->applyFromArray($styleArray);
        $sheet->getStyle('B')->applyFromArray($styleArray);

        //data
        $sheet->getStyle([2, 2, 5, count($this->data) + 2])->applyFromArray($contentStyle);
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $totalMonths = 0;
                $averageMonths = 0;
                $totalData = count($this->data);

                foreach ($this->data as $data) {
                    $string = $data['time_since_last_promotion'];
                    if (preg_match('/\d+(\.\d+)?/', $string, $matches)) {
                        $number = (float) $matches[0];
                        $totalMonths += $number;
                    }

                }

                if ($totalMonths > 0 && $totalData > 0) {
                    $averageMonths = number_format($totalMonths / $totalData, 2);
                }

                $averageStyle = array (
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER,
                        'wrapText' => true
                    ],
                    'font' => [
                        'bold' => true,
                    ],
                    'borders' => [
                        'top' => [
                            'borderStyle' => Border::BORDER_THIN,
                            'color' => array ('argb' => '00000000'),
                        ],
                    ],
                );

                $event->sheet->setCellValueByColumnAndRow(4, $totalData + 3, 'Average Duration till Promotion');
                $event->sheet->setCellValueByColumnAndRow(5, $totalData + 3, $averageMonths . ' months');
                $event->sheet->getStyleByColumnAndRow(4, $totalData + 3, 5, $totalData + 3)->applyFromArray($averageStyle);
            }
        ];
    }
}
