<?php

namespace Suiterus\Adg\Reports;

use Carbon\Carbon;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use Suiterus\Adg\Models\Reports\Reports;
use Suiterus\Adg\Models\Payroll\PayrollEmployee;
use Suiterus\Adg\Exports\Report\SpecialPayrollExport;

class SpecialPayrollReport
{
    use EmployerTrait;
    use EmployeeTrait;

    public function generate($reportId)
    {

        $report = Reports::find($reportId);

        $employeesPayroll = PayrollEmployee::whereHas('payroll', function ($query) use($report){
            $query->whereBetween('period_start', [$report->start_date, $report->end_date]);
        })->with([
            'earning_deduction' => function ($query) {
                $query->where('type', 1)->whereNotIn('name', ['Basic Pay']);
            }
        ])->get();

        $employeesSpecialPayrolls = [];
        $headers = count($employeesPayroll) > 0 ? ['Employee No.', 'Employee Name'] : [];

        foreach ($employeesPayroll as $employee) {
            foreach ($employee->earning_deduction as $earningDeduction) {
                if (!array_key_exists($employee->user->id, $employeesSpecialPayrolls)) {
                    $employeesSpecialPayrolls[$employee->user->id] = [
                        'Employee No.' => ' ' . $employee->user->employeeMetaInfo->employee_id . ' ',
                        'Employee Name' => $employee->user->name
                    ];
                }

                if (!in_array($earningDeduction->name, $headers)) {
                    $headers[] = $earningDeduction->name;
                }

                if (!array_key_exists($earningDeduction->name, $employeesSpecialPayrolls[$employee->user->id])) {
                    $employeesSpecialPayrolls[$employee->user->id][$earningDeduction->name] = round($earningDeduction->amount, 2);
                }else {
                    $employeesSpecialPayrolls[$employee->user->id][$earningDeduction->name] = round($employeesSpecialPayrolls[$employee->user->id][$earningDeduction->name] + $earningDeduction->amount, 2);
                }
            }
        }

        $path = Carbon::parse($report->start_date)->format('F-Y') . '-SPECIAL-PAYROLL-Report-' . $reportId . '.xlsx';

        (new SpecialPayrollExport(collect($employeesSpecialPayrolls), $headers))->store($path, 'generated_reports');

        return $path;
    }
}
