<?php

namespace Suiterus\Adg\Reports;

use alhimik1986\PhpExcelTemplator\params\ExcelParam;
use alhimik1986\PhpExcelTemplator\setters\CellSetterArrayValueSpecial;
use App\Enums\SalnStatus;
use App\Enums\Status;
use App\Models\User;
use Carbon\Carbon;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Exceptions\Reports\ReportException;
use Suiterus\Adg\Models\Reports\Reports;
use Suiterus\Adg\Models\Reports\SalnReports;
use Suiterus\Adg\Services\ReportService;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;

class SalnReport extends FileReport
{
    use EmployerTrait;
    use EmployeeTrait;

    public function generate($report_id)
    {
        $report = Reports::whereId($report_id)->with('creator')->first();
        $report_service = new ReportService;
        $path = $report_service->getFileTemplate($report->report_type);
        $this->initializeEmployerInfo($report->creator);
        $employer_name = $this->employers_name;
        $year = date('Y', strtotime($report->start_date));

        $filers = SalnReports::whereYear('created_at', $year)
            ->where('status', SalnStatus::APPROVED)
            ->with('user', 'user.employeeExtraField')
            ->get();

        if ($filers->isEmpty()) {
            throw new ReportException('There is no SALN Filers for this year selected');
        }
    
        foreach ($filers as $key => $filer) {
            $tin = $filer->user->employeeExtraField->pluck('employeeExtraFieldColumn')->flatten()->where('field_name', 'tin_id')->pluck('field_value')->first() ?? '';
            if ($tin) {
                if ($tin == 'N/A') {
                    $tin = '';
                }
            }

            $this->initializeEmployeeInfo($filer->user);
            $item_no[] = $key + 1;
            $last_name[] = $this->last_name;
            $first_name[] = $this->first_name;
            $middle_name[] = $this->middle_name;
            $tin_ids[] = $tin;
            $position[] = $filer->user->employeeMetaInfo->position->title;
            $net_worth[] = $filer->net_worth;
        }

        $total_filers = $filers->count();
        $total_users = User::whereNotIn('id', [1, 2])->where('status', Status::ACTIVE)->count();

        define('SPECIAL_ARRAY_TYPE', CellSetterArrayValueSpecial::class);
        //use special setter for array values to insert the whole row, and not insert cell with shifting down.
        return $this->exportToCSV([
            '{name_of_agency}' => $employer_name,
            '{calendar_year}' => Carbon::parse($report->end_date)->format('Y'),
            '[item_no]' => new ExcelParam(SPECIAL_ARRAY_TYPE, $item_no),
            '[last_name]' => new ExcelParam(SPECIAL_ARRAY_TYPE, $last_name),
            '[first_name]' => new ExcelParam(SPECIAL_ARRAY_TYPE, $first_name),
            '[middle_name]' => new ExcelParam(SPECIAL_ARRAY_TYPE, $middle_name),
            '[tin_no]' => new ExcelParam(SPECIAL_ARRAY_TYPE, $tin_ids),
            '[position]' => new ExcelParam(SPECIAL_ARRAY_TYPE, $position),
            '[net_worth]' => new ExcelParam(SPECIAL_ARRAY_TYPE, $net_worth),
            '{total_filers}' => $total_filers,
            '{total_employees}' => $total_users
        ], Carbon::now()->format('F-Y') . '-SALN-Report-' . $report->id . '.xlsx', $path);
    }
}
