<?php

namespace Suiterus\Adg\Reports;

use Carbon\Carbon;
use App\Models\User;
use App\Enums\Status;
use App\Enums\ReportType;
use App\Enums\ClearanceStatus;
use App\Enums\Log\ReportLogType;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use Suiterus\Adg\Models\Reports\Reports;
use Suiterus\Adg\Services\ReportService;
use Suiterus\Hrjp\Models\Applicant_account as AC;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;

class ResignedEmployeeReport extends FileReport
{
    use EmployeeTrait;
    use EmployerTrait;

    public function generate($reportId)
    {

        $total_number = 0;

        $report = Reports::whereId($reportId)->with('creator')->first();
        $report_service = new ReportService;

        $start_date = $report->start_date;
        $end_date = $report->end_date;

        $resigned_employees = User::whereHas('clearance', function ($query) use($start_date, $end_date){
            $query->where('status', ClearanceStatus::APPROVED)
            ->whereBetween('start_date', [$start_date, $end_date]);
        })
        ->where('status', Status::INACTIVE)
        ->without(['roles', 'permissions', 'storage', 'user_supervisor'])->get();

        $path = $report_service->getFileTemplate($report->report_type);
        $this->initializeEmployerInfo($report->creator);
        $employer_name = $this->employers_name;

        $indexes = [];
        $employees_fullname = [];
        $job_titles = [];
        $departments = [];
        $employees_type = [];
        $total_numbers = 0;

        foreach ($resigned_employees as $key => $resigned_employee) {

            $this->initializeEmployeeInfo($resigned_employee);
            $indexes[] = $key + 1;
            $employees_fullname[] = strtoupper($this->getFullName());
            $job_titles[] = $resigned_employee->employeeMetaInfo->position->title;
            $departments[] = $resigned_employee->employeeMetaInfo->department->name;
            $employees_type[] = $resigned_employee->employeeMetaInfo->employeeType->title;
        }

        $total_numbers = $resigned_employees->count() ?? 0;

        // Calling the 'exportToCSV' method and passing an associative array of data using 1D array
        // that will be used to populate placeholders in the CSV file per Column.
        return $this->exportToCSV([
            '{name_of_agency}' => $employer_name,
            '{month}' => strtoupper(Carbon::parse($report->end_date)->format('F')),
            '{year}' => strtoupper(Carbon::parse($report->end_date)->format('Y')),
            '[number]' => $indexes,
            '[employee_fullname]' => $employees_fullname,
            '[job_title]' => $job_titles,
            '[department]' => $departments,
            '[employee_type]' => $employees_type,
            '{total_number}' => $total_numbers,
        ],  Carbon::now()->format('F-Y') . '-Resigned-Employee-Report-' . $report->id . '.xlsx', $path);
    }
}
